/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerOpenException;
import io.github.resilience4j.core.StopWatch;
import io.reactivex.FlowableOperator;
import io.reactivex.ObservableOperator;
import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.SingleOperator;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircuitBreakerOperator<T>
implements ObservableOperator<T, T>,
FlowableOperator<T, T>,
SingleOperator<T, T> {
    private static final Logger LOG = LoggerFactory.getLogger(CircuitBreakerOperator.class);
    private final CircuitBreaker circuitBreaker;

    private CircuitBreakerOperator(CircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
    }

    public static <T> CircuitBreakerOperator<T> of(CircuitBreaker circuitBreaker) {
        return new CircuitBreakerOperator<T>(circuitBreaker);
    }

    public Subscriber<? super T> apply(Subscriber<? super T> childSubscriber) throws Exception {
        return new CircuitBreakerSubscriber(childSubscriber);
    }

    public Observer<? super T> apply(Observer<? super T> childObserver) throws Exception {
        return new CircuitBreakerObserver(childObserver);
    }

    public SingleObserver<? super T> apply(SingleObserver<? super T> childObserver) throws Exception {
        return new CircuitBreakerSingleObserver(childObserver);
    }

    private class CircuitBreakerSingleObserver
    implements SingleObserver<T>,
    Disposable {
        private final SingleObserver<? super T> childObserver;
        private Disposable disposable;
        private AtomicBoolean cancelled = new AtomicBoolean(false);
        private StopWatch stopWatch;

        CircuitBreakerSingleObserver(SingleObserver<? super T> childObserver) {
            this.childObserver = childObserver;
        }

        public void onSubscribe(Disposable disposable) {
            this.disposable = disposable;
            LOG.debug("onSubscribe");
            if (CircuitBreakerOperator.this.circuitBreaker.isCallPermitted()) {
                this.stopWatch = StopWatch.start((String)CircuitBreakerOperator.this.circuitBreaker.getName());
                this.childObserver.onSubscribe((Disposable)this);
            } else {
                disposable.dispose();
                this.childObserver.onSubscribe((Disposable)this);
                this.childObserver.onError((Throwable)new CircuitBreakerOpenException(String.format("CircuitBreaker '%s' is open", CircuitBreakerOperator.this.circuitBreaker.getName())));
            }
        }

        public void onError(Throwable e) {
            LOG.debug("onError", e);
            if (!this.isDisposed()) {
                CircuitBreakerOperator.this.circuitBreaker.onError(this.stopWatch.stop().getProcessingDuration().toNanos(), e);
                this.childObserver.onError(e);
            }
        }

        public void onSuccess(T value) {
            LOG.debug("onComplete");
            if (!this.isDisposed()) {
                CircuitBreakerOperator.this.circuitBreaker.onSuccess(this.stopWatch.stop().getProcessingDuration().toNanos());
                this.childObserver.onSuccess(value);
            }
        }

        public void dispose() {
            if (!this.cancelled.get()) {
                this.cancelled.set(true);
                this.disposable.dispose();
            }
        }

        public boolean isDisposed() {
            return this.cancelled.get();
        }
    }

    private final class CircuitBreakerObserver
    implements Observer<T>,
    Disposable {
        private final Observer<? super T> childObserver;
        private Disposable disposable;
        private AtomicBoolean cancelled = new AtomicBoolean(false);
        private StopWatch stopWatch;

        CircuitBreakerObserver(Observer<? super T> childObserver) {
            this.childObserver = childObserver;
        }

        public void onSubscribe(Disposable disposable) {
            this.disposable = disposable;
            LOG.debug("onSubscribe");
            if (CircuitBreakerOperator.this.circuitBreaker.isCallPermitted()) {
                this.stopWatch = StopWatch.start((String)CircuitBreakerOperator.this.circuitBreaker.getName());
                this.childObserver.onSubscribe((Disposable)this);
            } else {
                disposable.dispose();
                this.childObserver.onSubscribe((Disposable)this);
                this.childObserver.onError((Throwable)new CircuitBreakerOpenException(String.format("CircuitBreaker '%s' is open", CircuitBreakerOperator.this.circuitBreaker.getName())));
            }
        }

        public void onNext(T event) {
            LOG.debug("onNext: {}", event);
            if (!this.isDisposed()) {
                this.childObserver.onNext(event);
            }
        }

        public void onError(Throwable e) {
            LOG.debug("onError", e);
            if (!this.isDisposed()) {
                CircuitBreakerOperator.this.circuitBreaker.onError(this.stopWatch.stop().getProcessingDuration().toNanos(), e);
                this.childObserver.onError(e);
            }
        }

        public void onComplete() {
            LOG.debug("onComplete");
            if (!this.isDisposed()) {
                CircuitBreakerOperator.this.circuitBreaker.onSuccess(this.stopWatch.stop().getProcessingDuration().toNanos());
                this.childObserver.onComplete();
            }
        }

        public void dispose() {
            if (!this.cancelled.get()) {
                this.cancelled.set(true);
                this.disposable.dispose();
            }
        }

        public boolean isDisposed() {
            return this.cancelled.get();
        }
    }

    private final class CircuitBreakerSubscriber
    implements Subscriber<T>,
    Subscription {
        private final Subscriber<? super T> childSubscriber;
        private Subscription subscription;
        private AtomicBoolean cancelled = new AtomicBoolean(false);
        private StopWatch stopWatch;

        CircuitBreakerSubscriber(Subscriber<? super T> childSubscriber) {
            this.childSubscriber = childSubscriber;
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            LOG.debug("onSubscribe");
            if (CircuitBreakerOperator.this.circuitBreaker.isCallPermitted()) {
                this.stopWatch = StopWatch.start((String)CircuitBreakerOperator.this.circuitBreaker.getName());
                this.childSubscriber.onSubscribe((Subscription)this);
            } else {
                subscription.cancel();
                this.childSubscriber.onSubscribe((Subscription)this);
                this.childSubscriber.onError((Throwable)new CircuitBreakerOpenException(String.format("CircuitBreaker '%s' is open", CircuitBreakerOperator.this.circuitBreaker.getName())));
            }
        }

        public void onNext(T event) {
            LOG.debug("onNext: {}", event);
            if (!this.isCancelled()) {
                this.childSubscriber.onNext(event);
            }
        }

        public void onError(Throwable e) {
            LOG.debug("onError", e);
            if (!this.isCancelled()) {
                CircuitBreakerOperator.this.circuitBreaker.onError(this.stopWatch.stop().getProcessingDuration().toNanos(), e);
                this.childSubscriber.onError(e);
            }
        }

        public void onComplete() {
            LOG.debug("onComplete");
            if (!this.isCancelled()) {
                CircuitBreakerOperator.this.circuitBreaker.onSuccess(this.stopWatch.stop().getProcessingDuration().toNanos());
                this.childSubscriber.onComplete();
            }
        }

        public void request(long n) {
            this.subscription.request(n);
        }

        public void cancel() {
            if (!this.cancelled.get()) {
                this.cancelled.set(true);
                this.subscription.cancel();
            }
        }

        public boolean isCancelled() {
            return this.cancelled.get();
        }
    }
}

