/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker;

import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.core.predicate.PredicateCreator;
import java.time.Duration;
import java.util.function.Predicate;

public class CircuitBreakerConfig {
    public static final int DEFAULT_FAILURE_RATE_THRESHOLD = 50;
    public static final int DEFAULT_SLOW_CALL_RATE_THRESHOLD = 100;
    public static final int DEFAULT_WAIT_DURATION_IN_OPEN_STATE = 60;
    public static final int DEFAULT_PERMITTED_CALLS_IN_HALF_OPEN_STATE = 10;
    public static final int DEFAULT_MINIMUM_NUMBER_OF_CALLS = 100;
    public static final int DEFAULT_SLIDING_WINDOW_SIZE = 100;
    public static final int DEFAULT_SLOW_CALL_DURATION_THRESHOLD = 60;
    private static final Predicate<Throwable> DEFAULT_RECORD_EXCEPTION_PREDICATE = throwable -> true;
    private static final Predicate<Throwable> DEFAULT_IGNORE_EXCEPTION_PREDICATE = throwable -> false;
    public static final SlidingWindowType DEFAULT_SLIDING_WINDOW_TYPE = SlidingWindowType.COUNT_BASED;
    private Predicate<Throwable> recordExceptionPredicate = DEFAULT_RECORD_EXCEPTION_PREDICATE;
    private Predicate<Throwable> ignoreExceptionPredicate = DEFAULT_IGNORE_EXCEPTION_PREDICATE;
    private Class<? extends Throwable>[] recordExceptions = new Class[0];
    private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
    private float failureRateThreshold = 50.0f;
    private int permittedNumberOfCallsInHalfOpenState = 10;
    private int slidingWindowSize = 100;
    private SlidingWindowType slidingWindowType = DEFAULT_SLIDING_WINDOW_TYPE;
    private int minimumNumberOfCalls = 100;
    private Duration waitDurationInOpenState = Duration.ofSeconds(60L);
    private boolean automaticTransitionFromOpenToHalfOpenEnabled = false;
    private float slowCallRateThreshold = 100.0f;
    private Duration slowCallDurationThreshold = Duration.ofSeconds(60L);

    private CircuitBreakerConfig() {
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(CircuitBreakerConfig baseConfig) {
        return new Builder(baseConfig);
    }

    public static CircuitBreakerConfig ofDefaults() {
        return new Builder().build();
    }

    public float getFailureRateThreshold() {
        return this.failureRateThreshold;
    }

    public Duration getWaitDurationInOpenState() {
        return this.waitDurationInOpenState;
    }

    public int getSlidingWindowSize() {
        return this.slidingWindowSize;
    }

    public Predicate<Throwable> getRecordExceptionPredicate() {
        return this.recordExceptionPredicate;
    }

    public Predicate<Throwable> getIgnoreExceptionPredicate() {
        return this.ignoreExceptionPredicate;
    }

    public boolean isAutomaticTransitionFromOpenToHalfOpenEnabled() {
        return this.automaticTransitionFromOpenToHalfOpenEnabled;
    }

    public int getMinimumNumberOfCalls() {
        return this.minimumNumberOfCalls;
    }

    public int getPermittedNumberOfCallsInHalfOpenState() {
        return this.permittedNumberOfCallsInHalfOpenState;
    }

    public SlidingWindowType getSlidingWindowType() {
        return this.slidingWindowType;
    }

    public float getSlowCallRateThreshold() {
        return this.slowCallRateThreshold;
    }

    public Duration getSlowCallDurationThreshold() {
        return this.slowCallDurationThreshold;
    }

    static /* synthetic */ Class[] access$702(CircuitBreakerConfig x0, Class[] x1) {
        x0.recordExceptions = x1;
        return x1;
    }

    static /* synthetic */ Class[] access$602(CircuitBreakerConfig x0, Class[] x1) {
        x0.ignoreExceptions = x1;
        return x1;
    }

    public static enum SlidingWindowType {
        TIME_BASED,
        COUNT_BASED;

    }

    public static class Builder {
        @Nullable
        private Predicate<Throwable> recordExceptionPredicate;
        @Nullable
        private Predicate<Throwable> ignoreExceptionPredicate;
        private Class<? extends Throwable>[] recordExceptions = new Class[0];
        private Class<? extends Throwable>[] ignoreExceptions = new Class[0];
        private float failureRateThreshold = 50.0f;
        private int minimumNumberOfCalls = 100;
        private int permittedNumberOfCallsInHalfOpenState = 10;
        private int slidingWindowSize = 100;
        private Duration waitDurationInOpenState = Duration.ofSeconds(60L);
        private boolean automaticTransitionFromOpenToHalfOpenEnabled = false;
        private SlidingWindowType slidingWindowType = DEFAULT_SLIDING_WINDOW_TYPE;
        private float slowCallRateThreshold = 100.0f;
        private Duration slowCallDurationThreshold = Duration.ofSeconds(60L);

        public Builder(CircuitBreakerConfig baseConfig) {
            this.waitDurationInOpenState = baseConfig.waitDurationInOpenState;
            this.permittedNumberOfCallsInHalfOpenState = baseConfig.permittedNumberOfCallsInHalfOpenState;
            this.slidingWindowSize = baseConfig.slidingWindowSize;
            this.slidingWindowType = baseConfig.slidingWindowType;
            this.minimumNumberOfCalls = baseConfig.minimumNumberOfCalls;
            this.failureRateThreshold = baseConfig.failureRateThreshold;
            this.ignoreExceptions = baseConfig.ignoreExceptions;
            this.recordExceptions = baseConfig.recordExceptions;
            this.recordExceptionPredicate = baseConfig.recordExceptionPredicate;
            this.ignoreExceptionPredicate = baseConfig.ignoreExceptionPredicate;
            this.automaticTransitionFromOpenToHalfOpenEnabled = baseConfig.automaticTransitionFromOpenToHalfOpenEnabled;
            this.slowCallRateThreshold = baseConfig.slowCallRateThreshold;
            this.slowCallDurationThreshold = baseConfig.slowCallDurationThreshold;
        }

        public Builder() {
        }

        public Builder failureRateThreshold(float failureRateThreshold) {
            if (failureRateThreshold <= 0.0f || failureRateThreshold > 100.0f) {
                throw new IllegalArgumentException("failureRateThreshold must be between 1 and 100");
            }
            this.failureRateThreshold = failureRateThreshold;
            return this;
        }

        public Builder slowCallRateThreshold(float slowCallRateThreshold) {
            if (slowCallRateThreshold <= 0.0f || slowCallRateThreshold > 100.0f) {
                throw new IllegalArgumentException("slowCallRateThreshold must be between 1 and 100");
            }
            this.slowCallRateThreshold = slowCallRateThreshold;
            return this;
        }

        public Builder waitDurationInOpenState(Duration waitDurationInOpenState) {
            if (waitDurationInOpenState.toMillis() < 1L) {
                throw new IllegalArgumentException("waitDurationInOpenState must be at least 1[ms]");
            }
            this.waitDurationInOpenState = waitDurationInOpenState;
            return this;
        }

        public Builder slowCallDurationThreshold(Duration slowCallDurationThreshold) {
            if (slowCallDurationThreshold.toNanos() < 1L) {
                throw new IllegalArgumentException("slowCallDurationThreshold must be at least 1[ns]");
            }
            this.slowCallDurationThreshold = slowCallDurationThreshold;
            return this;
        }

        public Builder permittedNumberOfCallsInHalfOpenState(int permittedNumberOfCallsInHalfOpenState) {
            if (permittedNumberOfCallsInHalfOpenState < 1) {
                throw new IllegalArgumentException("permittedNumberOfCallsInHalfOpenState must be greater than 0");
            }
            this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
            return this;
        }

        @Deprecated
        public Builder ringBufferSizeInHalfOpenState(int ringBufferSizeInHalfOpenState) {
            if (ringBufferSizeInHalfOpenState < 1) {
                throw new IllegalArgumentException("ringBufferSizeInHalfOpenState must be greater than 0");
            }
            this.permittedNumberOfCallsInHalfOpenState = ringBufferSizeInHalfOpenState;
            return this;
        }

        @Deprecated
        public Builder ringBufferSizeInClosedState(int ringBufferSizeInClosedState) {
            if (ringBufferSizeInClosedState < 1) {
                throw new IllegalArgumentException("ringBufferSizeInClosedState must be greater than 0");
            }
            return this.slidingWindow(ringBufferSizeInClosedState, ringBufferSizeInClosedState, SlidingWindowType.COUNT_BASED);
        }

        public Builder slidingWindow(int slidingWindowSize, int minimumNumberOfCalls, SlidingWindowType slidingWindowType) {
            if (slidingWindowSize < 1) {
                throw new IllegalArgumentException("slidingWindowSize must be greater than 0");
            }
            if (minimumNumberOfCalls < 1) {
                throw new IllegalArgumentException("minimumNumberOfCalls must be greater than 0");
            }
            this.minimumNumberOfCalls = slidingWindowType == SlidingWindowType.COUNT_BASED ? Math.min(minimumNumberOfCalls, slidingWindowSize) : minimumNumberOfCalls;
            this.slidingWindowSize = slidingWindowSize;
            this.slidingWindowType = slidingWindowType;
            return this;
        }

        public Builder slidingWindowSize(int slidingWindowSize) {
            if (slidingWindowSize < 1) {
                throw new IllegalArgumentException("slidingWindowSize must be greater than 0");
            }
            this.slidingWindowSize = slidingWindowSize;
            return this;
        }

        public Builder minimumNumberOfCalls(int minimumNumberOfCalls) {
            if (minimumNumberOfCalls < 1) {
                throw new IllegalArgumentException("minimumNumberOfCalls must be greater than 0");
            }
            this.minimumNumberOfCalls = minimumNumberOfCalls;
            return this;
        }

        public Builder slidingWindowType(SlidingWindowType slidingWindowType) {
            this.slidingWindowType = slidingWindowType;
            return this;
        }

        @Deprecated
        public Builder recordFailure(Predicate<Throwable> predicate) {
            this.recordExceptionPredicate = predicate;
            return this;
        }

        public Builder recordException(Predicate<Throwable> predicate) {
            this.recordExceptionPredicate = predicate;
            return this;
        }

        public Builder ignoreException(Predicate<Throwable> predicate) {
            this.ignoreExceptionPredicate = predicate;
            return this;
        }

        @SafeVarargs
        public final Builder recordExceptions(Class<? extends Throwable> ... errorClasses) {
            this.recordExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        @SafeVarargs
        public final Builder ignoreExceptions(Class<? extends Throwable> ... errorClasses) {
            this.ignoreExceptions = errorClasses != null ? errorClasses : new Class[]{};
            return this;
        }

        public Builder enableAutomaticTransitionFromOpenToHalfOpen() {
            this.automaticTransitionFromOpenToHalfOpenEnabled = true;
            return this;
        }

        public Builder automaticTransitionFromOpenToHalfOpenEnabled(boolean enableAutomaticTransitionFromOpenToHalfOpen) {
            this.automaticTransitionFromOpenToHalfOpenEnabled = enableAutomaticTransitionFromOpenToHalfOpen;
            return this;
        }

        public CircuitBreakerConfig build() {
            CircuitBreakerConfig config = new CircuitBreakerConfig();
            config.waitDurationInOpenState = this.waitDurationInOpenState;
            config.slidingWindowType = this.slidingWindowType;
            config.slowCallDurationThreshold = this.slowCallDurationThreshold;
            config.slowCallRateThreshold = this.slowCallRateThreshold;
            config.failureRateThreshold = this.failureRateThreshold;
            config.slidingWindowSize = this.slidingWindowSize;
            config.minimumNumberOfCalls = this.minimumNumberOfCalls;
            config.permittedNumberOfCallsInHalfOpenState = this.permittedNumberOfCallsInHalfOpenState;
            CircuitBreakerConfig.access$702(config, this.recordExceptions);
            CircuitBreakerConfig.access$602(config, this.ignoreExceptions);
            config.automaticTransitionFromOpenToHalfOpenEnabled = this.automaticTransitionFromOpenToHalfOpenEnabled;
            config.recordExceptionPredicate = this.createRecordExceptionPredicate();
            config.ignoreExceptionPredicate = this.createIgnoreFailurePredicate();
            return config;
        }

        private Predicate<Throwable> createIgnoreFailurePredicate() {
            return PredicateCreator.createExceptionsPredicate((Class[])this.ignoreExceptions).map(predicate -> this.ignoreExceptionPredicate != null ? predicate.or(this.ignoreExceptionPredicate) : predicate).orElseGet(() -> this.ignoreExceptionPredicate != null ? this.ignoreExceptionPredicate : DEFAULT_IGNORE_EXCEPTION_PREDICATE);
        }

        private Predicate<Throwable> createRecordExceptionPredicate() {
            return PredicateCreator.createExceptionsPredicate((Class[])this.recordExceptions).map(predicate -> this.recordExceptionPredicate != null ? predicate.or(this.recordExceptionPredicate) : predicate).orElseGet(() -> this.recordExceptionPredicate != null ? this.recordExceptionPredicate : DEFAULT_RECORD_EXCEPTION_PREDICATE);
        }
    }
}

