/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.internal;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.core.metrics.FixedSizeSlidingWindowMetrics;
import io.github.resilience4j.core.metrics.Metrics;
import io.github.resilience4j.core.metrics.SlidingTimeWindowMetrics;
import io.github.resilience4j.core.metrics.Snapshot;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

class CircuitBreakerMetrics
implements CircuitBreaker.Metrics {
    private final Metrics metrics;
    private final float failureRateThreshold;
    private final float slowCallRateThreshold;
    private final long slowCallDurationThresholdInNanos;
    private int minimumNumberOfCalls;
    private final LongAdder numberOfNotPermittedCalls;

    private CircuitBreakerMetrics(int slidingWindowSize, CircuitBreakerConfig.SlidingWindowType slidingWindowType, CircuitBreakerConfig circuitBreakerConfig) {
        if (slidingWindowType == CircuitBreakerConfig.SlidingWindowType.COUNT_BASED) {
            this.metrics = new FixedSizeSlidingWindowMetrics(slidingWindowSize);
            this.minimumNumberOfCalls = Math.min(circuitBreakerConfig.getMinimumNumberOfCalls(), slidingWindowSize);
        } else {
            this.metrics = new SlidingTimeWindowMetrics(slidingWindowSize);
            this.minimumNumberOfCalls = circuitBreakerConfig.getMinimumNumberOfCalls();
        }
        this.failureRateThreshold = circuitBreakerConfig.getFailureRateThreshold();
        this.slowCallRateThreshold = circuitBreakerConfig.getSlowCallRateThreshold();
        this.slowCallDurationThresholdInNanos = circuitBreakerConfig.getSlowCallDurationThreshold().toNanos();
        this.numberOfNotPermittedCalls = new LongAdder();
    }

    private CircuitBreakerMetrics(int slidingWindowSize, CircuitBreakerConfig circuitBreakerConfig) {
        this(slidingWindowSize, circuitBreakerConfig.getSlidingWindowType(), circuitBreakerConfig);
    }

    static CircuitBreakerMetrics forCosed(CircuitBreakerConfig circuitBreakerConfig) {
        return new CircuitBreakerMetrics(circuitBreakerConfig.getSlidingWindowSize(), circuitBreakerConfig);
    }

    static CircuitBreakerMetrics forHalfOpen(int permittedNumberOfCallsInHalfOpenState, CircuitBreakerConfig circuitBreakerConfig) {
        return new CircuitBreakerMetrics(permittedNumberOfCallsInHalfOpenState, CircuitBreakerConfig.SlidingWindowType.COUNT_BASED, circuitBreakerConfig);
    }

    static CircuitBreakerMetrics forForcedOpen(CircuitBreakerConfig circuitBreakerConfig) {
        return new CircuitBreakerMetrics(0, CircuitBreakerConfig.SlidingWindowType.COUNT_BASED, circuitBreakerConfig);
    }

    static CircuitBreakerMetrics forDisabled(CircuitBreakerConfig circuitBreakerConfig) {
        return new CircuitBreakerMetrics(0, CircuitBreakerConfig.SlidingWindowType.COUNT_BASED, circuitBreakerConfig);
    }

    void onCallNotPermitted() {
        this.numberOfNotPermittedCalls.increment();
    }

    public Result onSuccess(long duration, TimeUnit durationUnit) {
        Snapshot snapshot = durationUnit.toNanos(duration) > this.slowCallDurationThresholdInNanos ? this.metrics.record(duration, durationUnit, Metrics.Outcome.SLOW_SUCCESS) : this.metrics.record(duration, durationUnit, Metrics.Outcome.SUCCESS);
        return this.checkIfThresholdsExceeded(snapshot);
    }

    public Result onError(long duration, TimeUnit durationUnit) {
        Snapshot snapshot = durationUnit.toNanos(duration) > this.slowCallDurationThresholdInNanos ? this.metrics.record(duration, durationUnit, Metrics.Outcome.SLOW_ERROR) : this.metrics.record(duration, durationUnit, Metrics.Outcome.ERROR);
        return this.checkIfThresholdsExceeded(snapshot);
    }

    private Result checkIfThresholdsExceeded(Snapshot snapshot) {
        float failureRateInPercentage = this.getFailureRate(snapshot);
        if (failureRateInPercentage == -1.0f) {
            return Result.BELOW_MINIMUM_CALLS_THRESHOLD;
        }
        if (failureRateInPercentage >= this.failureRateThreshold) {
            return Result.ABOVE_THRESHOLDS;
        }
        float slowCallsInPercentage = this.getSlowCallRate(snapshot);
        if (slowCallsInPercentage >= this.slowCallRateThreshold) {
            return Result.ABOVE_THRESHOLDS;
        }
        return Result.BELOW_THRESHOLDS;
    }

    private float getSlowCallRate(Snapshot snapshot) {
        int bufferedCalls = snapshot.getTotalNumberOfCalls();
        if (bufferedCalls == 0 || bufferedCalls < this.minimumNumberOfCalls) {
            return -1.0f;
        }
        return snapshot.getSlowCallRate();
    }

    private float getFailureRate(Snapshot snapshot) {
        int bufferedCalls = snapshot.getTotalNumberOfCalls();
        if (bufferedCalls == 0 || bufferedCalls < this.minimumNumberOfCalls) {
            return -1.0f;
        }
        return snapshot.getFailureRate();
    }

    @Override
    public float getFailureRate() {
        return this.getFailureRate(this.metrics.getSnapshot());
    }

    @Override
    public float getSlowCallRate() {
        return this.getSlowCallRate(this.metrics.getSnapshot());
    }

    @Override
    public int getNumberOfSuccessfulCalls() {
        return this.metrics.getSnapshot().getNumberOfSuccessfulCalls();
    }

    @Override
    public int getNumberOfBufferedCalls() {
        return this.metrics.getSnapshot().getTotalNumberOfCalls();
    }

    @Override
    public int getNumberOfFailedCalls() {
        return this.metrics.getSnapshot().getNumberOfFailedCalls();
    }

    @Override
    public int getNumberOfSlowCalls() {
        return this.metrics.getSnapshot().getNumberOfSlowCalls();
    }

    @Override
    public long getNumberOfNotPermittedCalls() {
        return this.numberOfNotPermittedCalls.sum();
    }

    static enum Result {
        BELOW_THRESHOLDS,
        ABOVE_THRESHOLDS,
        BELOW_MINIMUM_CALLS_THRESHOLD;

    }
}

