/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.commons.configuration.bulkhead.configure;

import io.github.resilience4j.common.bulkhead.configuration.CommonBulkheadConfigurationProperties;
import io.github.resilience4j.commons.configuration.exception.ConfigParseException;
import io.github.resilience4j.commons.configuration.util.StringParseUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.configuration2.Configuration;

public class CommonsConfigurationBulkHeadConfiguration
extends CommonBulkheadConfigurationProperties {
    private static final String BULK_HEAD_CONFIGS_PREFIX = "resilience4j.bulkhead.configs";
    private static final String BULK_HEAD_INSTANCES_PREFIX = "resilience4j.bulkhead.instances";
    private static final String MAX_CONCURRENT_CALLS = "maxConcurrentCalls";
    private static final String MAX_WAIT_DURATION = "maxWaitDuration";
    private static final String WRITABLE_STACK_TRACE_ENABLED = "writableStackTraceEnabled";
    private static final String EVENT_CONSUMER_BUFFER_SIZE = "eventConsumerBufferSize";
    private final Function<Configuration, CommonBulkheadConfigurationProperties.InstanceProperties> mapConfigurationToInstanceProperties = configuration -> {
        CommonBulkheadConfigurationProperties.InstanceProperties instanceProperties = new CommonBulkheadConfigurationProperties.InstanceProperties();
        if (configuration.containsKey(MAX_CONCURRENT_CALLS)) {
            instanceProperties.setMaxConcurrentCalls(Integer.valueOf(configuration.getInt(MAX_CONCURRENT_CALLS)));
        }
        if (configuration.containsKey(MAX_WAIT_DURATION)) {
            instanceProperties.setMaxWaitDuration(configuration.getDuration(MAX_WAIT_DURATION));
        }
        if (configuration.containsKey(WRITABLE_STACK_TRACE_ENABLED)) {
            instanceProperties.setWritableStackTraceEnabled(Boolean.valueOf(configuration.getBoolean(WRITABLE_STACK_TRACE_ENABLED)));
        }
        if (configuration.containsKey("baseConfig")) {
            instanceProperties.setBaseConfig(configuration.getString("baseConfig"));
        }
        if (configuration.containsKey(EVENT_CONSUMER_BUFFER_SIZE)) {
            instanceProperties.setEventConsumerBufferSize(Integer.valueOf(configuration.getInt(EVENT_CONSUMER_BUFFER_SIZE)));
        }
        return instanceProperties;
    };

    private CommonsConfigurationBulkHeadConfiguration() {
    }

    public static CommonsConfigurationBulkHeadConfiguration of(Configuration configuration) throws ConfigParseException {
        CommonsConfigurationBulkHeadConfiguration obj = new CommonsConfigurationBulkHeadConfiguration();
        try {
            obj.getConfigs().putAll(obj.getProperties(configuration.subset(BULK_HEAD_CONFIGS_PREFIX)));
            obj.getInstances().putAll(obj.getProperties(configuration.subset(BULK_HEAD_INSTANCES_PREFIX)));
            return obj;
        }
        catch (Exception ex) {
            throw new ConfigParseException("Error creating bulkhead configuration", ex);
        }
    }

    private Map<String, CommonBulkheadConfigurationProperties.InstanceProperties> getProperties(Configuration configuration) {
        Set<String> uniqueInstances = StringParseUtil.extractUniquePrefixes(configuration.getKeys(), ".");
        HashMap<String, CommonBulkheadConfigurationProperties.InstanceProperties> instanceConfigsMap = new HashMap<String, CommonBulkheadConfigurationProperties.InstanceProperties>();
        uniqueInstances.forEach(instance -> instanceConfigsMap.put((String)instance, this.mapConfigurationToInstanceProperties.apply(configuration.subset(instance))));
        return instanceConfigsMap;
    }
}

