/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.commons.configuration.ratelimiter.configure;

import io.github.resilience4j.common.ratelimiter.configuration.CommonRateLimiterConfigurationProperties;
import io.github.resilience4j.commons.configuration.exception.ConfigParseException;
import io.github.resilience4j.commons.configuration.util.StringParseUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.configuration2.Configuration;

public class CommonsConfigurationRateLimiterConfiguration
extends CommonRateLimiterConfigurationProperties {
    private static final String RATE_LIMITER_CONFIGS_PREFIX = "resilience4j.ratelimiter.configs";
    private static final String RATE_LIMITER_INSTANCES_PREFIX = "resilience4j.ratelimiter.instances";
    protected static final String BASE_CONFIG = "baseConfig";
    protected static final String LIMIT_FOR_PERIOD = "limitForPeriod";
    protected static final String LIMIT_REFRESH_PERIOD = "limitRefreshPeriod";
    protected static final String TIMEOUT_DURATION = "timeoutDuration";
    protected static final String SUBSCRIBE_FOR_EVENTS = "subscribeForEvents";
    protected static final String ALLOW_HEALTH_INDICATOR_TO_FAIL = "allowHealthIndicatorToFail";
    protected static final String REGISTER_HEALTH_INDICATOR = "registerHealthIndicator";
    protected static final String EVENT_CONSUMER_BUFFER_SIZE = "eventConsumerBufferSize";
    protected static final String WRITABLE_STACK_TRACE_ENABLED = "writableStackTraceEnabled";
    private final Function<Configuration, CommonRateLimiterConfigurationProperties.InstanceProperties> mapConfigurationToInstanceProperties = configuration -> {
        CommonRateLimiterConfigurationProperties.InstanceProperties instanceProperties = new CommonRateLimiterConfigurationProperties.InstanceProperties();
        if (configuration.containsKey(BASE_CONFIG)) {
            instanceProperties.setBaseConfig(configuration.getString(BASE_CONFIG));
        }
        if (configuration.containsKey(LIMIT_FOR_PERIOD)) {
            instanceProperties.setLimitForPeriod(Integer.valueOf(configuration.getInt(LIMIT_FOR_PERIOD)));
        }
        if (configuration.containsKey(LIMIT_REFRESH_PERIOD)) {
            instanceProperties.setLimitRefreshPeriod(configuration.getDuration(LIMIT_REFRESH_PERIOD));
        }
        if (configuration.containsKey(TIMEOUT_DURATION)) {
            instanceProperties.setTimeoutDuration(configuration.getDuration(TIMEOUT_DURATION));
        }
        if (configuration.containsKey(SUBSCRIBE_FOR_EVENTS)) {
            instanceProperties.setSubscribeForEvents(Boolean.valueOf(configuration.getBoolean(SUBSCRIBE_FOR_EVENTS)));
        }
        if (configuration.containsKey(ALLOW_HEALTH_INDICATOR_TO_FAIL)) {
            instanceProperties.setAllowHealthIndicatorToFail(Boolean.valueOf(configuration.getBoolean(ALLOW_HEALTH_INDICATOR_TO_FAIL)));
        }
        if (configuration.containsKey(REGISTER_HEALTH_INDICATOR)) {
            instanceProperties.setRegisterHealthIndicator(Boolean.valueOf(configuration.getBoolean(REGISTER_HEALTH_INDICATOR)));
        }
        if (configuration.containsKey(EVENT_CONSUMER_BUFFER_SIZE)) {
            instanceProperties.setEventConsumerBufferSize(Integer.valueOf(configuration.getInt(EVENT_CONSUMER_BUFFER_SIZE)));
        }
        if (configuration.containsKey(WRITABLE_STACK_TRACE_ENABLED)) {
            instanceProperties.setWritableStackTraceEnabled(Boolean.valueOf(configuration.getBoolean(WRITABLE_STACK_TRACE_ENABLED)));
        }
        return instanceProperties;
    };

    private CommonsConfigurationRateLimiterConfiguration() {
    }

    public static CommonsConfigurationRateLimiterConfiguration of(Configuration configuration) throws ConfigParseException {
        CommonsConfigurationRateLimiterConfiguration obj = new CommonsConfigurationRateLimiterConfiguration();
        try {
            obj.getConfigs().putAll(obj.getProperties(configuration.subset(RATE_LIMITER_CONFIGS_PREFIX)));
            obj.getInstances().putAll(obj.getProperties(configuration.subset(RATE_LIMITER_INSTANCES_PREFIX)));
            return obj;
        }
        catch (Exception ex) {
            throw new ConfigParseException("Error creating ratelimiter configuration", ex);
        }
    }

    private Map<String, CommonRateLimiterConfigurationProperties.InstanceProperties> getProperties(Configuration configuration) {
        Set<String> uniqueInstances = StringParseUtil.extractUniquePrefixes(configuration.getKeys(), ".");
        HashMap<String, CommonRateLimiterConfigurationProperties.InstanceProperties> instanceConfigsMap = new HashMap<String, CommonRateLimiterConfigurationProperties.InstanceProperties>();
        uniqueInstances.forEach(instance -> instanceConfigsMap.put((String)instance, this.mapConfigurationToInstanceProperties.apply(configuration.subset(instance))));
        return instanceConfigsMap;
    }
}

