/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.commons.configuration.timelimiter.configure;

import io.github.resilience4j.common.timelimiter.configuration.CommonTimeLimiterConfigurationProperties;
import io.github.resilience4j.commons.configuration.exception.ConfigParseException;
import io.github.resilience4j.commons.configuration.util.StringParseUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.configuration2.Configuration;

public class CommonsConfigurationTimeLimiterConfiguration
extends CommonTimeLimiterConfigurationProperties {
    private static final String TIME_LIMITER_CONFIGS_PREFIX = "resilience4j.timelimiter.configs";
    private static final String TIME_LIMITER_INSTANCES_PREFIX = "resilience4j.timelimiter.instances";
    private static final String TIMEOUT_DURATION = "timeoutDuration";
    private static final String CANCEL_RUNNING_FUTURE = "cancelRunningFuture";
    private static final String EVENT_CONSUMER_BUFFER_SIZE = "eventConsumerBufferSize";
    private final Function<Configuration, CommonTimeLimiterConfigurationProperties.InstanceProperties> mapConfigurationToInstanceProperties = configuration -> {
        CommonTimeLimiterConfigurationProperties.InstanceProperties instanceProperties = new CommonTimeLimiterConfigurationProperties.InstanceProperties();
        if (configuration.containsKey("baseConfig")) {
            instanceProperties.setBaseConfig(configuration.getString("baseConfig"));
        }
        if (configuration.containsKey(TIMEOUT_DURATION)) {
            instanceProperties.setTimeoutDuration(configuration.getDuration(TIMEOUT_DURATION));
        }
        if (configuration.containsKey(CANCEL_RUNNING_FUTURE)) {
            instanceProperties.setCancelRunningFuture(Boolean.valueOf(configuration.getBoolean(CANCEL_RUNNING_FUTURE)));
        }
        if (configuration.containsKey(EVENT_CONSUMER_BUFFER_SIZE)) {
            instanceProperties.setEventConsumerBufferSize(Integer.valueOf(configuration.getInt(EVENT_CONSUMER_BUFFER_SIZE)));
        }
        return instanceProperties;
    };

    private CommonsConfigurationTimeLimiterConfiguration() {
    }

    public static CommonsConfigurationTimeLimiterConfiguration of(Configuration configuration) throws ConfigParseException {
        CommonsConfigurationTimeLimiterConfiguration obj = new CommonsConfigurationTimeLimiterConfiguration();
        try {
            obj.getConfigs().putAll(obj.getProperties(configuration.subset(TIME_LIMITER_CONFIGS_PREFIX)));
            obj.getInstances().putAll(obj.getProperties(configuration.subset(TIME_LIMITER_INSTANCES_PREFIX)));
            return obj;
        }
        catch (Exception ex) {
            throw new ConfigParseException("Error creating timelimiter configuration", ex);
        }
    }

    private Map<String, CommonTimeLimiterConfigurationProperties.InstanceProperties> getProperties(Configuration configuration) {
        Set<String> uniqueInstances = StringParseUtil.extractUniquePrefixes(configuration.getKeys(), ".");
        HashMap<String, CommonTimeLimiterConfigurationProperties.InstanceProperties> instanceConfigsMap = new HashMap<String, CommonTimeLimiterConfigurationProperties.InstanceProperties>();
        uniqueInstances.forEach(instance -> instanceConfigsMap.put((String)instance, this.mapConfigurationToInstanceProperties.apply(configuration.subset(instance))));
        return instanceConfigsMap;
    }
}

