/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.commons.configuration.util;

import io.github.resilience4j.commons.configuration.exception.ConfigParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StringParseUtil {
    public static Set<String> extractUniquePrefixes(Iterator<String> iterator, String delimiter) {
        HashSet<String> uniquePrefixes = new HashSet<String>();
        try {
            iterator.forEachRemaining(element -> {
                String prefix = element.substring(0, element.indexOf(delimiter));
                uniquePrefixes.add(prefix);
            });
            return uniquePrefixes;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConfigParseException(String.format("Unable to extract prefix with delimiter: %s", delimiter), e);
        }
    }
}

