/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.feign;

import io.github.resilience4j.core.functions.CheckedFunction;
import io.github.resilience4j.feign.FallbackHandler;
import java.lang.reflect.Method;
import java.util.function.Predicate;

class DefaultFallbackHandler<T>
implements FallbackHandler<T> {
    private final T fallback;

    DefaultFallbackHandler(T fallback) {
        this.fallback = fallback;
    }

    @Override
    public CheckedFunction<Object[], Object> decorate(CheckedFunction<Object[], Object> invocationCall, Method method, Predicate<Exception> filter) {
        Method fallbackMethod = this.validateAndGetFallbackMethod(this.fallback, method);
        return args -> {
            try {
                return invocationCall.apply(args);
            }
            catch (Exception exception) {
                if (filter.test(exception)) {
                    return fallbackMethod.invoke(this.fallback, args);
                }
                throw exception;
            }
        };
    }
}

