/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.circuitbreaker.configuration;

import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ClassUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.time.DurationMin;

public class CircuitBreakerConfigurationProperties {
    private Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public Optional<InstanceProperties> findCircuitBreakerProperties(String name) {
        InstanceProperties instanceProperties = this.instances.get(name);
        if (instanceProperties == null) {
            instanceProperties = this.configs.get("default");
        }
        return Optional.ofNullable(instanceProperties);
    }

    public CircuitBreakerConfig createCircuitBreakerConfig(InstanceProperties instanceProperties) {
        if (StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            return this.buildConfigFromBaseConfig(instanceProperties, baseProperties);
        }
        return this.buildConfig(CircuitBreakerConfig.custom(), instanceProperties);
    }

    private CircuitBreakerConfig buildConfigFromBaseConfig(InstanceProperties instanceProperties, InstanceProperties baseProperties) {
        ConfigUtils.mergePropertiesIfAny(instanceProperties, baseProperties);
        CircuitBreakerConfig baseConfig = this.buildConfig(CircuitBreakerConfig.custom(), baseProperties);
        return this.buildConfig(CircuitBreakerConfig.from((CircuitBreakerConfig)baseConfig), instanceProperties);
    }

    private CircuitBreakerConfig buildConfig(CircuitBreakerConfig.Builder builder, InstanceProperties properties) {
        if (properties == null) {
            return builder.build();
        }
        if (properties.getWaitDurationInOpenState() != null) {
            builder.waitDurationInOpenState(properties.getWaitDurationInOpenState());
        }
        if (properties.getFailureRateThreshold() != null) {
            builder.failureRateThreshold(properties.getFailureRateThreshold().floatValue());
        }
        if (properties.getWritableStackTraceEnabled() != null) {
            builder.writableStackTraceEnabled(properties.getWritableStackTraceEnabled().booleanValue());
        }
        if (properties.getSlowCallRateThreshold() != null) {
            builder.slowCallRateThreshold(properties.getSlowCallRateThreshold().floatValue());
        }
        if (properties.getSlowCallDurationThreshold() != null) {
            builder.slowCallDurationThreshold(properties.getSlowCallDurationThreshold());
        }
        if (properties.getRingBufferSizeInClosedState() != null) {
            builder.ringBufferSizeInClosedState(properties.getRingBufferSizeInClosedState().intValue());
        }
        if (properties.getSlidingWindowSize() != null) {
            builder.slidingWindowSize(properties.getSlidingWindowSize().intValue());
        }
        if (properties.getMinimumNumberOfCalls() != null) {
            builder.minimumNumberOfCalls(properties.getMinimumNumberOfCalls().intValue());
        }
        if (properties.getSlidingWindowType() != null) {
            builder.slidingWindowType(properties.getSlidingWindowType());
        }
        if (properties.getRingBufferSizeInHalfOpenState() != null) {
            builder.ringBufferSizeInHalfOpenState(properties.getRingBufferSizeInHalfOpenState().intValue());
        }
        if (properties.getPermittedNumberOfCallsInHalfOpenState() != null) {
            builder.permittedNumberOfCallsInHalfOpenState(properties.getPermittedNumberOfCallsInHalfOpenState().intValue());
        }
        if (properties.recordFailurePredicate != null) {
            this.buildRecordFailurePredicate(properties, builder);
        }
        if (properties.recordExceptions != null) {
            builder.recordExceptions(properties.recordExceptions);
        }
        if (properties.ignoreExceptions != null) {
            builder.ignoreExceptions(properties.ignoreExceptions);
        }
        if (properties.automaticTransitionFromOpenToHalfOpenEnabled != null) {
            builder.automaticTransitionFromOpenToHalfOpenEnabled(properties.automaticTransitionFromOpenToHalfOpenEnabled.booleanValue());
        }
        return builder.build();
    }

    private void buildRecordFailurePredicate(InstanceProperties properties, CircuitBreakerConfig.Builder builder) {
        Predicate predicate;
        if (properties.getRecordFailurePredicate() != null && (predicate = ClassUtils.instantiatePredicateClass(properties.getRecordFailurePredicate())) != null) {
            builder.recordException(predicate);
        }
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        return this.instances.get(backend);
    }

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    public static class InstanceProperties {
        @DurationMin(millis=1L)
        @Nullable
        private @DurationMin(millis=1L) Duration waitDurationInOpenState;
        @DurationMin(nanos=1L)
        @Nullable
        private @DurationMin(nanos=1L) Duration slowCallDurationThreshold;
        @Min(value=1L)
        @Max(value=100L)
        @Nullable
        private @Min(value=1L) @Max(value=100L) Float failureRateThreshold;
        @Min(value=1L)
        @Max(value=100L)
        @Nullable
        private @Min(value=1L) @Max(value=100L) Float slowCallRateThreshold;
        @Min(value=1L)
        @Nullable
        @Deprecated
        private @Min(value=1L) Integer ringBufferSizeInClosedState;
        @Nullable
        private CircuitBreakerConfig.SlidingWindowType slidingWindowType;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer slidingWindowSize;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer minimumNumberOfCalls;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer permittedNumberOfCallsInHalfOpenState;
        @Min(value=1L)
        @Nullable
        @Deprecated
        private @Min(value=1L) Integer ringBufferSizeInHalfOpenState;
        @Nullable
        private Boolean automaticTransitionFromOpenToHalfOpenEnabled;
        @Nullable
        private Boolean writableStackTraceEnabled;
        @Min(value=1L)
        @Nullable
        private @Min(value=1L) Integer eventConsumerBufferSize;
        @Nullable
        private Boolean registerHealthIndicator;
        @Nullable
        private Class<Predicate<Throwable>> recordFailurePredicate;
        @Nullable
        private Class<? extends Throwable>[] recordExceptions;
        @Nullable
        private Class<? extends Throwable>[] ignoreExceptions;
        @Nullable
        private String baseConfig;

        @Nullable
        public Float getFailureRateThreshold() {
            return this.failureRateThreshold;
        }

        public InstanceProperties setFailureRateThreshold(Float failureRateThreshold) {
            this.failureRateThreshold = failureRateThreshold;
            return this;
        }

        @Nullable
        public Duration getWaitDurationInOpenState() {
            return this.waitDurationInOpenState;
        }

        public InstanceProperties setWaitDurationInOpenState(Duration waitDurationInOpenStateMillis) {
            this.waitDurationInOpenState = waitDurationInOpenStateMillis;
            return this;
        }

        @Nullable
        public Integer getRingBufferSizeInClosedState() {
            return this.ringBufferSizeInClosedState;
        }

        @Deprecated
        public InstanceProperties setRingBufferSizeInClosedState(Integer ringBufferSizeInClosedState) {
            this.ringBufferSizeInClosedState = ringBufferSizeInClosedState;
            return this;
        }

        @Nullable
        public Integer getRingBufferSizeInHalfOpenState() {
            return this.ringBufferSizeInHalfOpenState;
        }

        @Deprecated
        public InstanceProperties setRingBufferSizeInHalfOpenState(Integer ringBufferSizeInHalfOpenState) {
            this.ringBufferSizeInHalfOpenState = ringBufferSizeInHalfOpenState;
            return this;
        }

        public Boolean getAutomaticTransitionFromOpenToHalfOpenEnabled() {
            return this.automaticTransitionFromOpenToHalfOpenEnabled;
        }

        public InstanceProperties setAutomaticTransitionFromOpenToHalfOpenEnabled(Boolean automaticTransitionFromOpenToHalfOpenEnabled) {
            this.automaticTransitionFromOpenToHalfOpenEnabled = automaticTransitionFromOpenToHalfOpenEnabled;
            return this;
        }

        public Boolean getWritableStackTraceEnabled() {
            return this.writableStackTraceEnabled;
        }

        public InstanceProperties setWritableStackTraceEnabled(Boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled = writableStackTraceEnabled;
            return this;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        public Boolean getRegisterHealthIndicator() {
            return this.registerHealthIndicator;
        }

        public InstanceProperties setRegisterHealthIndicator(Boolean registerHealthIndicator) {
            this.registerHealthIndicator = registerHealthIndicator;
            return this;
        }

        @Nullable
        public Class<Predicate<Throwable>> getRecordFailurePredicate() {
            return this.recordFailurePredicate;
        }

        public InstanceProperties setRecordFailurePredicate(Class<Predicate<Throwable>> recordFailurePredicate) {
            this.recordFailurePredicate = recordFailurePredicate;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getRecordExceptions() {
            return this.recordExceptions;
        }

        public InstanceProperties setRecordExceptions(Class<? extends Throwable>[] recordExceptions) {
            this.recordExceptions = recordExceptions;
            return this;
        }

        @Nullable
        public Class<? extends Throwable>[] getIgnoreExceptions() {
            return this.ignoreExceptions;
        }

        public InstanceProperties setIgnoreExceptions(Class<? extends Throwable>[] ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }

        @Nullable
        public Integer getPermittedNumberOfCallsInHalfOpenState() {
            return this.permittedNumberOfCallsInHalfOpenState;
        }

        public void setPermittedNumberOfCallsInHalfOpenState(@Nullable Integer permittedNumberOfCallsInHalfOpenState) {
            this.permittedNumberOfCallsInHalfOpenState = permittedNumberOfCallsInHalfOpenState;
        }

        @Nullable
        public Integer getMinimumNumberOfCalls() {
            return this.minimumNumberOfCalls;
        }

        public void setMinimumNumberOfCalls(@Nullable Integer minimumNumberOfCalls) {
            this.minimumNumberOfCalls = minimumNumberOfCalls;
        }

        @Nullable
        public Integer getSlidingWindowSize() {
            return this.slidingWindowSize;
        }

        public void setSlidingWindowSize(@Nullable Integer slidingWindowSize) {
            this.slidingWindowSize = slidingWindowSize;
        }

        @Nullable
        public Float getSlowCallRateThreshold() {
            return this.slowCallRateThreshold;
        }

        public void setSlowCallRateThreshold(@Nullable Float slowCallRateThreshold) {
            this.slowCallRateThreshold = slowCallRateThreshold;
        }

        @Nullable
        public Duration getSlowCallDurationThreshold() {
            return this.slowCallDurationThreshold;
        }

        public void setSlowCallDurationThreshold(@Nullable Duration slowCallDurationThreshold) {
            this.slowCallDurationThreshold = slowCallDurationThreshold;
        }

        @Nullable
        public CircuitBreakerConfig.SlidingWindowType getSlidingWindowType() {
            return this.slidingWindowType;
        }

        public void setSlidingWindowType(CircuitBreakerConfig.SlidingWindowType slidingWindowType) {
            this.slidingWindowType = slidingWindowType;
        }
    }
}

