/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.bulkhead.configuration;

import io.github.resilience4j.bulkhead.ThreadPoolBulkheadConfig;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ThreadPoolBulkheadConfigurationProperties {
    private Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getBackends() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    @Nullable
    public InstanceProperties getBackendProperties(String backend) {
        return this.instances.get(backend);
    }

    public ThreadPoolBulkheadConfig createThreadPoolBulkheadConfig(String backend) {
        return this.createThreadPoolBulkheadConfig(this.getBackendProperties(backend));
    }

    public ThreadPoolBulkheadConfig createThreadPoolBulkheadConfig(InstanceProperties instanceProperties) {
        if (instanceProperties != null && StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            return this.buildThreadPoolConfigFromBaseConfig(baseProperties, instanceProperties);
        }
        return this.buildThreadPoolBulkheadConfig(ThreadPoolBulkheadConfig.custom(), instanceProperties);
    }

    private ThreadPoolBulkheadConfig buildThreadPoolConfigFromBaseConfig(InstanceProperties baseProperties, InstanceProperties instanceProperties) {
        ThreadPoolBulkheadConfig baseConfig = this.buildThreadPoolBulkheadConfig(ThreadPoolBulkheadConfig.custom(), baseProperties);
        return this.buildThreadPoolBulkheadConfig(ThreadPoolBulkheadConfig.from((ThreadPoolBulkheadConfig)baseConfig), instanceProperties);
    }

    public ThreadPoolBulkheadConfig buildThreadPoolBulkheadConfig(ThreadPoolBulkheadConfig.Builder builder, InstanceProperties properties) {
        if (properties == null) {
            return ThreadPoolBulkheadConfig.custom().build();
        }
        if (properties.getQueueCapacity() > 0) {
            builder.queueCapacity(properties.getQueueCapacity());
        }
        if (properties.getCoreThreadPoolSize() > 0) {
            builder.coreThreadPoolSize(properties.getCoreThreadPoolSize());
        }
        if (properties.getMaxThreadPoolSize() > 0) {
            builder.maxThreadPoolSize(properties.getMaxThreadPoolSize());
        }
        if (properties.getKeepAliveDuration() != null) {
            builder.keepAliveDuration(properties.getKeepAliveDuration());
        }
        if (properties.getWritableStackTraceEnabled() != null) {
            builder.writableStackTraceEnabled(properties.getWritableStackTraceEnabled().booleanValue());
        }
        return builder.build();
    }

    public static class InstanceProperties {
        @Nullable
        private Integer eventConsumerBufferSize;
        @Nullable
        private String baseConfig;
        @Nullable
        private Boolean writableStackTraceEnabled;
        private int maxThreadPoolSize;
        private int coreThreadPoolSize;
        private int queueCapacity;
        private Duration keepAliveDuration;

        public int getMaxThreadPoolSize() {
            return this.maxThreadPoolSize;
        }

        public InstanceProperties setMaxThreadPoolSize(int maxThreadPoolSize) {
            this.maxThreadPoolSize = maxThreadPoolSize;
            return this;
        }

        public int getCoreThreadPoolSize() {
            return this.coreThreadPoolSize;
        }

        public InstanceProperties setCoreThreadPoolSize(int coreThreadPoolSize) {
            this.coreThreadPoolSize = coreThreadPoolSize;
            return this;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public InstanceProperties setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return this;
        }

        public Duration getKeepAliveDuration() {
            return this.keepAliveDuration;
        }

        public InstanceProperties setKeepAliveDuration(Duration keepAliveDuration) {
            this.keepAliveDuration = keepAliveDuration;
            return this;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            Objects.requireNonNull(eventConsumerBufferSize);
            if (eventConsumerBufferSize < 1) {
                throw new IllegalArgumentException("eventConsumerBufferSize must be greater than or equal to 1.");
            }
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        public Boolean getWritableStackTraceEnabled() {
            return this.writableStackTraceEnabled;
        }

        public InstanceProperties setWritableStackTraceEnabled(Integer eventConsumerBufferSize) {
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }
    }
}

