/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.ratelimiter.configuration;

import io.github.resilience4j.common.CommonProperties;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.ratelimiter.configuration.RateLimiterConfigCustomizer;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CommonRateLimiterConfigurationProperties
extends CommonProperties {
    private static final String DEFAULT = "default";
    private Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public Optional<InstanceProperties> findRateLimiterProperties(String name) {
        InstanceProperties instanceProperties = this.instances.get(name);
        if (instanceProperties == null) {
            instanceProperties = this.configs.get(DEFAULT);
        } else if (this.configs.get(DEFAULT) != null) {
            ConfigUtils.mergePropertiesIfAny(this.configs.get(DEFAULT), instanceProperties);
        }
        return Optional.ofNullable(instanceProperties);
    }

    public RateLimiterConfig createRateLimiterConfig(@Nullable InstanceProperties instanceProperties, CompositeCustomizer<RateLimiterConfigCustomizer> compositeRateLimiterCustomizer, String instanceName) {
        RateLimiterConfig baseConfig = null;
        if (instanceProperties != null && StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            ConfigUtils.mergePropertiesIfAny(baseProperties, instanceProperties);
            baseConfig = this.createRateLimiterConfig(baseProperties, compositeRateLimiterCustomizer, instanceProperties.getBaseConfig());
        } else if (!instanceName.equals(DEFAULT) && this.configs.get(DEFAULT) != null) {
            if (instanceProperties != null) {
                ConfigUtils.mergePropertiesIfAny(this.configs.get(DEFAULT), instanceProperties);
            }
            baseConfig = this.createRateLimiterConfig(this.configs.get(DEFAULT), compositeRateLimiterCustomizer, DEFAULT);
        }
        return this.buildConfig(baseConfig != null ? RateLimiterConfig.from(baseConfig) : RateLimiterConfig.custom(), instanceProperties, compositeRateLimiterCustomizer, instanceName);
    }

    private RateLimiterConfig buildConfig(RateLimiterConfig.Builder builder, @Nullable InstanceProperties instanceProperties, CompositeCustomizer<RateLimiterConfigCustomizer> compositeRateLimiterCustomizer, String instanceName) {
        if (instanceProperties != null) {
            if (instanceProperties.getLimitForPeriod() != null) {
                builder.limitForPeriod(instanceProperties.getLimitForPeriod().intValue());
            }
            if (instanceProperties.getLimitRefreshPeriod() != null) {
                builder.limitRefreshPeriod(instanceProperties.getLimitRefreshPeriod());
            }
            if (instanceProperties.getTimeoutDuration() != null) {
                builder.timeoutDuration(instanceProperties.getTimeoutDuration());
            }
            if (instanceProperties.getWritableStackTraceEnabled() != null) {
                builder.writableStackTraceEnabled(instanceProperties.getWritableStackTraceEnabled().booleanValue());
            }
        }
        compositeRateLimiterCustomizer.getCustomizer(instanceName).ifPresent(rateLimiterConfigCustomizer -> rateLimiterConfigCustomizer.customize(builder));
        return builder.build();
    }

    private InstanceProperties getLimiterProperties(String limiter) {
        return this.instances.get(limiter);
    }

    public RateLimiterConfig createRateLimiterConfig(String limiter, CompositeCustomizer<RateLimiterConfigCustomizer> compositeRateLimiterCustomizer) {
        return this.createRateLimiterConfig(this.getLimiterProperties(limiter), compositeRateLimiterCustomizer, limiter);
    }

    @Nullable
    public InstanceProperties getInstanceProperties(String instance) {
        return this.instances.get(instance);
    }

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getLimiters() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    public static class InstanceProperties {
        private Integer limitForPeriod;
        private Duration limitRefreshPeriod;
        private Duration timeoutDuration;
        @Nullable
        private Boolean subscribeForEvents;
        @Nullable
        private Boolean allowHealthIndicatorToFail;
        @Nullable
        private Boolean registerHealthIndicator;
        @Nullable
        private Integer eventConsumerBufferSize;
        @Nullable
        private Boolean writableStackTraceEnabled;
        @Nullable
        private String baseConfig;

        @Nullable
        public Integer getLimitForPeriod() {
            return this.limitForPeriod;
        }

        public InstanceProperties setLimitForPeriod(Integer limitForPeriod) {
            this.limitForPeriod = limitForPeriod;
            return this;
        }

        @Nullable
        public Duration getLimitRefreshPeriod() {
            return this.limitRefreshPeriod;
        }

        public InstanceProperties setLimitRefreshPeriod(Duration limitRefreshPeriod) {
            this.limitRefreshPeriod = limitRefreshPeriod;
            return this;
        }

        @Nullable
        public Duration getTimeoutDuration() {
            return this.timeoutDuration;
        }

        public InstanceProperties setTimeoutDuration(Duration timeout) {
            this.timeoutDuration = timeout;
            return this;
        }

        public Boolean getWritableStackTraceEnabled() {
            return this.writableStackTraceEnabled;
        }

        public InstanceProperties setWritableStackTraceEnabled(Boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled = writableStackTraceEnabled;
            return this;
        }

        public Boolean getSubscribeForEvents() {
            return this.subscribeForEvents;
        }

        public InstanceProperties setSubscribeForEvents(Boolean subscribeForEvents) {
            this.subscribeForEvents = subscribeForEvents;
            return this;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            Objects.requireNonNull(eventConsumerBufferSize);
            if (eventConsumerBufferSize < 1) {
                throw new IllegalArgumentException("eventConsumerBufferSize must be greater than or equal to 1.");
            }
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }

        @Nullable
        public Boolean getAllowHealthIndicatorToFail() {
            return this.allowHealthIndicatorToFail;
        }

        public InstanceProperties setAllowHealthIndicatorToFail(Boolean allowHealthIndicatorToFail) {
            this.allowHealthIndicatorToFail = allowHealthIndicatorToFail;
            return this;
        }

        public Boolean getRegisterHealthIndicator() {
            return this.registerHealthIndicator;
        }

        public InstanceProperties setRegisterHealthIndicator(Boolean registerHealthIndicator) {
            this.registerHealthIndicator = registerHealthIndicator;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }
    }
}

