/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.micrometer.configuration;

import io.github.resilience4j.common.CommonProperties;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.micrometer.configuration.TimerConfigCustomizer;
import io.github.resilience4j.common.utils.ConfigUtils;
import io.github.resilience4j.core.ClassUtils;
import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.StringUtils;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.micrometer.TimerConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class CommonTimerConfigurationProperties
extends CommonProperties {
    private static final String DEFAULT = "default";
    private final Map<String, InstanceProperties> instances = new HashMap<String, InstanceProperties>();
    private final Map<String, InstanceProperties> configs = new HashMap<String, InstanceProperties>();

    public TimerConfig createTimerConfig(String instance, CompositeCustomizer<TimerConfigCustomizer> compositeTimerCustomizer) {
        return this.createTimerConfig(this.instances.get(instance), compositeTimerCustomizer, instance);
    }

    @Nullable
    public InstanceProperties getInstanceProperties(String instance) {
        InstanceProperties instanceProperties = this.instances.get(instance);
        if (instanceProperties == null) {
            instanceProperties = this.configs.get(DEFAULT);
        } else if (this.configs.get(DEFAULT) != null) {
            ConfigUtils.mergePropertiesIfAny(this.configs.get(DEFAULT), instanceProperties);
        }
        return instanceProperties;
    }

    public Map<String, InstanceProperties> getInstances() {
        return this.instances;
    }

    public Map<String, InstanceProperties> getConfigs() {
        return this.configs;
    }

    public TimerConfig createTimerConfig(@Nullable InstanceProperties instanceProperties, CompositeCustomizer<TimerConfigCustomizer> compositeTimerCustomizer, String instanceName) {
        TimerConfig baseConfig = null;
        if (instanceProperties != null && StringUtils.isNotEmpty((String)instanceProperties.getBaseConfig())) {
            InstanceProperties baseProperties = this.configs.get(instanceProperties.getBaseConfig());
            if (baseProperties == null) {
                throw new ConfigurationNotFoundException(instanceProperties.getBaseConfig());
            }
            ConfigUtils.mergePropertiesIfAny(baseProperties, instanceProperties);
            baseConfig = this.createTimerConfig(baseProperties, compositeTimerCustomizer, instanceProperties.getBaseConfig());
        } else if (!instanceName.equals(DEFAULT) && this.configs.get(DEFAULT) != null) {
            if (instanceProperties != null) {
                ConfigUtils.mergePropertiesIfAny(this.configs.get(DEFAULT), instanceProperties);
            }
            baseConfig = this.createTimerConfig(this.configs.get(DEFAULT), compositeTimerCustomizer, DEFAULT);
        }
        return this.buildConfig(baseConfig != null ? TimerConfig.from(baseConfig) : TimerConfig.custom(), instanceProperties, compositeTimerCustomizer, instanceName);
    }

    private TimerConfig buildConfig(TimerConfig.Builder builder, @Nullable InstanceProperties properties, CompositeCustomizer<TimerConfigCustomizer> compositeTimerCustomizer, String instance) {
        if (properties != null) {
            if (properties.getMetricNames() != null) {
                builder.metricNames(properties.getMetricNames());
            }
            if (properties.getOnFailureTagResolver() != null) {
                Function function = ClassUtils.instantiateFunction(properties.getOnFailureTagResolver());
                builder.onFailureTagResolver(function);
            }
        }
        compositeTimerCustomizer.getCustomizer(instance).ifPresent(customizer -> customizer.customize(builder));
        return builder.build();
    }

    public static class InstanceProperties {
        @Nullable
        private String metricNames;
        @Nullable
        private Class<? extends Function<Throwable, String>> onFailureTagResolver;
        @Nullable
        private String baseConfig;
        @Nullable
        private Integer eventConsumerBufferSize;

        @Nullable
        public String getMetricNames() {
            return this.metricNames;
        }

        public InstanceProperties setMetricNames(@Nullable String metricNames) {
            this.metricNames = metricNames;
            return this;
        }

        @Nullable
        public Class<? extends Function<Throwable, String>> getOnFailureTagResolver() {
            return this.onFailureTagResolver;
        }

        public InstanceProperties setOnFailureTagResolver(@Nullable Class<? extends Function<Throwable, String>> onFailureTagResolver) {
            this.onFailureTagResolver = onFailureTagResolver;
            return this;
        }

        @Nullable
        public String getBaseConfig() {
            return this.baseConfig;
        }

        public InstanceProperties setBaseConfig(String baseConfig) {
            this.baseConfig = baseConfig;
            return this;
        }

        public Integer getEventConsumerBufferSize() {
            return this.eventConsumerBufferSize;
        }

        public InstanceProperties setEventConsumerBufferSize(Integer eventConsumerBufferSize) {
            Objects.requireNonNull(eventConsumerBufferSize, "eventConsumerBufferSize must not be null");
            if (eventConsumerBufferSize < 1) {
                throw new IllegalArgumentException("eventConsumerBufferSize must be greater than or equal to 1");
            }
            this.eventConsumerBufferSize = eventConsumerBufferSize;
            return this;
        }
    }
}

