/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RateLimiterMetrics
implements MetricSet {
    private static final String PREFIX_NULL = "Prefix must not be null";
    private static final String ITERABLE_NULL = "RateLimiters iterable must not be null";
    private final MetricRegistry metricRegistry;

    private RateLimiterMetrics(Iterable<RateLimiter> rateLimiters) {
        this("resilience4j.ratelimiter", rateLimiters, new MetricRegistry());
    }

    private RateLimiterMetrics(String prefix, Iterable<RateLimiter> rateLimiters, MetricRegistry metricRegistry) {
        Objects.requireNonNull(prefix, PREFIX_NULL);
        Objects.requireNonNull(rateLimiters, ITERABLE_NULL);
        Objects.requireNonNull(metricRegistry);
        this.metricRegistry = metricRegistry;
        rateLimiters.forEach(rateLimiter -> {
            String name = rateLimiter.getName();
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "number_of_waiting_threads"}), (Metric)((Gauge)() -> ((RateLimiter.Metrics)rateLimiter.getMetrics()).getNumberOfWaitingThreads()));
            metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{name, "available_permissions"}), (Metric)((Gauge)() -> ((RateLimiter.Metrics)rateLimiter.getMetrics()).getAvailablePermissions()));
        });
    }

    public static RateLimiterMetrics ofRateLimiterRegistry(String prefix, RateLimiterRegistry rateLimiterRegistry, MetricRegistry metricRegistry) {
        return new RateLimiterMetrics(prefix, rateLimiterRegistry.getAllRateLimiters(), metricRegistry);
    }

    public static RateLimiterMetrics ofRateLimiterRegistry(String prefix, RateLimiterRegistry rateLimiterRegistry) {
        return new RateLimiterMetrics(prefix, rateLimiterRegistry.getAllRateLimiters(), new MetricRegistry());
    }

    public static RateLimiterMetrics ofRateLimiterRegistry(RateLimiterRegistry rateLimiterRegistry, MetricRegistry metricRegistry) {
        return new RateLimiterMetrics("resilience4j.ratelimiter", rateLimiterRegistry.getAllRateLimiters(), metricRegistry);
    }

    public static RateLimiterMetrics ofRateLimiterRegistry(RateLimiterRegistry rateLimiterRegistry) {
        return new RateLimiterMetrics(rateLimiterRegistry.getAllRateLimiters());
    }

    public static RateLimiterMetrics ofIterable(Iterable<RateLimiter> rateLimiters) {
        return new RateLimiterMetrics(rateLimiters);
    }

    public static RateLimiterMetrics ofIterable(String prefix, Iterable<RateLimiter> rateLimiters) {
        return new RateLimiterMetrics(prefix, rateLimiters, new MetricRegistry());
    }

    public static RateLimiterMetrics ofRateLimiter(RateLimiter rateLimiter) {
        return new RateLimiterMetrics(List.of(rateLimiter));
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }
}

