/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics.publisher;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.metrics.publisher.AbstractMetricsPublisher;
import io.github.resilience4j.timelimiter.TimeLimiter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class TimeLimiterMetricsPublisher
extends AbstractMetricsPublisher<TimeLimiter> {
    private final String prefix;

    public TimeLimiterMetricsPublisher() {
        this("resilience4j.timelimiter", new MetricRegistry());
    }

    public TimeLimiterMetricsPublisher(MetricRegistry metricRegistry) {
        this("resilience4j.timelimiter", metricRegistry);
    }

    public TimeLimiterMetricsPublisher(String prefix, MetricRegistry metricRegistry) {
        super(metricRegistry);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public void publishMetrics(TimeLimiter timeLimiter) {
        String name = timeLimiter.getName();
        String successfulName = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "successful"});
        String failedName = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "failed"});
        String timeoutName = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "timeout"});
        Counter successes = this.metricRegistry.counter(successfulName);
        Counter failures = this.metricRegistry.counter(failedName);
        Counter timeouts = this.metricRegistry.counter(timeoutName);
        timeLimiter.getEventPublisher().onSuccess(event -> successes.inc());
        timeLimiter.getEventPublisher().onError(event -> failures.inc());
        timeLimiter.getEventPublisher().onTimeout(event -> timeouts.inc());
        List<String> metricNames = Arrays.asList(successfulName, failedName, timeoutName);
        this.metricsNameMap.put(name, new HashSet<String>(metricNames));
    }

    public void removeMetrics(TimeLimiter timeLimiter) {
        this.removeMetrics(timeLimiter.getName());
    }
}

