/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer;

import io.github.resilience4j.micrometer.MetricUtils;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;

public class RetryMetrics
implements MeterBinder {
    private final Iterable<Retry> retries;
    private final String prefix;

    private RetryMetrics(Iterable<Retry> retries) {
        this(retries, "resilience4j.retry");
    }

    private RetryMetrics(Iterable<Retry> retries, String prefix) {
        this.retries = Objects.requireNonNull(retries);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public static RetryMetrics ofRetryRegistry(RetryRegistry retryRegistry) {
        return new RetryMetrics((Iterable<Retry>)retryRegistry.getAllRetries());
    }

    public void bindTo(MeterRegistry registry) {
        for (Retry retry : this.retries) {
            String name = retry.getName();
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "successful_calls_without_retry"), (Object)retry, cb -> cb.getMetrics().getNumberOfSuccessfulCallsWithoutRetryAttempt()).register(registry);
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "successful_calls_with_retry"), (Object)retry, cb -> cb.getMetrics().getNumberOfSuccessfulCallsWithRetryAttempt()).register(registry);
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "failed_calls_without_retry"), (Object)retry, cb -> cb.getMetrics().getNumberOfFailedCallsWithoutRetryAttempt()).register(registry);
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "failed_calls_with_retry"), (Object)retry, cb -> cb.getMetrics().getNumberOfFailedCallsWithRetryAttempt()).register(registry);
        }
    }
}

