/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.micrometer.MetricUtils;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;

public class BulkheadMetrics
implements MeterBinder {
    private final Iterable<Bulkhead> bulkheads;
    private final String prefix;

    private BulkheadMetrics(Iterable<Bulkhead> bulkheads) {
        this(bulkheads, "resilience4j.bulkhead");
    }

    private BulkheadMetrics(Iterable<Bulkhead> bulkheads, String prefix) {
        this.bulkheads = Objects.requireNonNull(bulkheads);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public static BulkheadMetrics ofBulkheadRegistry(BulkheadRegistry bulkheadRegistry) {
        return new BulkheadMetrics((Iterable<Bulkhead>)bulkheadRegistry.getAllBulkheads());
    }

    public void bindTo(MeterRegistry registry) {
        for (Bulkhead bulkhead : this.bulkheads) {
            String name = bulkhead.getName();
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "available_concurrent_calls"), (Object)bulkhead, cb -> cb.getMetrics().getAvailableConcurrentCalls()).register(registry);
        }
    }
}

