/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.MetricUtils;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;

public class CircuitBreakerMetrics
implements MeterBinder {
    private final Iterable<CircuitBreaker> circuitBreakers;
    private final String prefix;

    private CircuitBreakerMetrics(Iterable<CircuitBreaker> circuitBreakers) {
        this(circuitBreakers, "resilience4j.circuitbreaker");
    }

    private CircuitBreakerMetrics(Iterable<CircuitBreaker> circuitBreakers, String prefix) {
        this.circuitBreakers = Objects.requireNonNull(circuitBreakers);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public static CircuitBreakerMetrics ofCircuitBreakerRegistry(CircuitBreakerRegistry circuitBreakerRegistry) {
        return new CircuitBreakerMetrics((Iterable<CircuitBreaker>)circuitBreakerRegistry.getAllCircuitBreakers());
    }

    public static CircuitBreakerMetrics ofIterable(Iterable<CircuitBreaker> circuitBreakers) {
        return new CircuitBreakerMetrics(circuitBreakers);
    }

    public static CircuitBreakerMetrics ofIterable(String prefix, Iterable<CircuitBreaker> circuitBreakers) {
        return new CircuitBreakerMetrics(circuitBreakers, prefix);
    }

    public void bindTo(MeterRegistry registry) {
        for (CircuitBreaker circuitBreaker : this.circuitBreakers) {
            String name = circuitBreaker.getName();
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "state"), (Object)circuitBreaker, cb -> cb.getState().getOrder()).register(registry);
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "buffered_max"), (Object)circuitBreaker, cb -> cb.getMetrics().getMaxNumberOfBufferedCalls()).register(registry);
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "buffered"), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfBufferedCalls()).register(registry);
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "failed"), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfFailedCalls()).register(registry);
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "not_permitted"), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfNotPermittedCalls()).register(registry);
            Gauge.builder((String)MetricUtils.getName(this.prefix, name, "successful"), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfSuccessfulCalls()).register(registry);
        }
    }
}

