/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;

public class TaggedCircuitBreakerMetrics
implements MeterBinder {
    private final MetricNames names;
    private final Iterable<? extends CircuitBreaker> circuitBreakers;

    public static TaggedCircuitBreakerMetrics ofCircuitBreakerRegistry(MetricNames metricNames, CircuitBreakerRegistry registry) {
        return new TaggedCircuitBreakerMetrics(metricNames, (Iterable<? extends CircuitBreaker>)registry.getAllCircuitBreakers());
    }

    public static TaggedCircuitBreakerMetrics ofCircuitBreakerRegistry(CircuitBreakerRegistry registry) {
        return TaggedCircuitBreakerMetrics.ofCircuitBreakerRegistry(MetricNames.ofDefaults(), registry);
    }

    private TaggedCircuitBreakerMetrics(MetricNames names, Iterable<? extends CircuitBreaker> circuitBreakers) {
        this.names = Objects.requireNonNull(names);
        this.circuitBreakers = Objects.requireNonNull(circuitBreakers);
    }

    public void bindTo(MeterRegistry registry) {
        for (CircuitBreaker circuitBreaker : this.circuitBreakers) {
            Gauge.builder((String)this.names.getStateMetricName(), (Object)circuitBreaker, cb -> cb.getState().getOrder()).tag("name", circuitBreaker.getName()).register(registry);
            Gauge.builder((String)this.names.getCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfFailedCalls()).tag("name", circuitBreaker.getName()).tag("kind", "failed").register(registry);
            Gauge.builder((String)this.names.getCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfNotPermittedCalls()).tag("name", circuitBreaker.getName()).tag("kind", "not_permitted").register(registry);
            Gauge.builder((String)this.names.getCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfSuccessfulCalls()).tag("name", circuitBreaker.getName()).tag("kind", "successful").register(registry);
            Gauge.builder((String)this.names.getBufferedCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfBufferedCalls()).tag("name", circuitBreaker.getName()).register(registry);
            Gauge.builder((String)this.names.getMaxBufferedCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getMaxNumberOfBufferedCalls()).tag("name", circuitBreaker.getName()).register(registry);
        }
    }

    public static class MetricNames {
        public static final String DEFAULT_CIRCUIT_BREAKER_CALLS_METRIC_NAME = "resilience4j_circuitbreaker_calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_STATE_METRIC_NAME = "resilience4j_circuitbreaker_state";
        public static final String DEFAULT_CIRCUIT_BREAKER_BUFFERED_CALLS = "resilience4j_circuitbreaker_buffered_calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_MAX_BUFFERED_CALLS = "resilience4j_circuitbreaker_max_buffered_calls";
        private String callsMetricName = "resilience4j_circuitbreaker_calls";
        private String stateMetricName = "resilience4j_circuitbreaker_state";
        private String bufferedCallsMetricName = "resilience4j_circuitbreaker_buffered_calls";
        private String maxBufferedCallsMetricName = "resilience4j_circuitbreaker_max_buffered_calls";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        private MetricNames() {
        }

        public String getCallsMetricName() {
            return this.callsMetricName;
        }

        public String getBufferedCallsMetricName() {
            return this.bufferedCallsMetricName;
        }

        public String getMaxBufferedCallsMetricName() {
            return this.maxBufferedCallsMetricName;
        }

        public String getStateMetricName() {
            return this.stateMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder callsMetricName(String callsMetricName) {
                this.metricNames.callsMetricName = Objects.requireNonNull(callsMetricName);
                return this;
            }

            public Builder stateMetricName(String stateMetricName) {
                this.metricNames.stateMetricName = Objects.requireNonNull(stateMetricName);
                return this;
            }

            public Builder bufferedCallsMetricName(String bufferedCallsMetricName) {
                this.metricNames.bufferedCallsMetricName = Objects.requireNonNull(bufferedCallsMetricName);
                return this;
            }

            public Builder maxBufferedCallsMetricName(String maxBufferedCallsMetricName) {
                this.metricNames.maxBufferedCallsMetricName = Objects.requireNonNull(maxBufferedCallsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

