/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;

public class TaggedRetryMetrics
implements MeterBinder {
    private final MetricNames names;
    private final Iterable<? extends Retry> retries;

    public static TaggedRetryMetrics ofRetryRegistry(RetryRegistry registry) {
        return new TaggedRetryMetrics(MetricNames.ofDefaults(), (Iterable<? extends Retry>)registry.getAllRetries());
    }

    public static TaggedRetryMetrics ofRetryRegistry(MetricNames names, RetryRegistry registry) {
        return new TaggedRetryMetrics(names, (Iterable<? extends Retry>)registry.getAllRetries());
    }

    private TaggedRetryMetrics(MetricNames names, Iterable<? extends Retry> retries) {
        this.names = Objects.requireNonNull(names);
        this.retries = Objects.requireNonNull(retries);
    }

    public void bindTo(MeterRegistry registry) {
        for (Retry retry : this.retries) {
            Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfSuccessfulCallsWithoutRetryAttempt()).tag("name", retry.getName()).tag("kind", "successful_without_retry").register(registry);
            Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfSuccessfulCallsWithRetryAttempt()).tag("name", retry.getName()).tag("kind", "successful_with_retry").register(registry);
            Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfFailedCallsWithoutRetryAttempt()).tag("name", retry.getName()).tag("kind", "failed_without_retry").register(registry);
            Gauge.builder((String)this.names.getCallsMetricName(), (Object)retry, rt -> rt.getMetrics().getNumberOfFailedCallsWithRetryAttempt()).tag("name", retry.getName()).tag("kind", "failed_with_retry").register(registry);
        }
    }

    public static class MetricNames {
        public static final String DEFAULT_RETRY_CALLS = "resilience4j_retry_calls";
        private String callsMetricName = "resilience4j_retry_calls";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        private MetricNames() {
        }

        public String getCallsMetricName() {
            return this.callsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder callsMetricName(String callsMetricName) {
                this.metricNames.callsMetricName = Objects.requireNonNull(callsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

