/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.HashSet;
import java.util.Objects;

public class TaggedCircuitBreakerMetrics
extends AbstractMetrics
implements MeterBinder {
    private static final String KIND_STATE = "state";
    private static final String KIND_FAILED = "failed";
    private static final String KIND_SUCCESSFUL = "successful";
    private static final String KIND_IGNORED = "ignored";
    private static final String KIND_NOT_PERMITTED = "not_permitted";
    private final MetricNames names;
    private final CircuitBreakerRegistry circuitBreakerRegistry;

    public static TaggedCircuitBreakerMetrics ofCircuitBreakerRegistry(CircuitBreakerRegistry circuitBreakerRegistry) {
        return new TaggedCircuitBreakerMetrics(MetricNames.ofDefaults(), circuitBreakerRegistry);
    }

    public static TaggedCircuitBreakerMetrics ofCircuitBreakerRegistry(MetricNames metricNames, CircuitBreakerRegistry circuitBreakerRegistry) {
        return new TaggedCircuitBreakerMetrics(metricNames, circuitBreakerRegistry);
    }

    private TaggedCircuitBreakerMetrics(MetricNames names, CircuitBreakerRegistry circuitBreakerRegistry) {
        this.names = Objects.requireNonNull(names);
        this.circuitBreakerRegistry = Objects.requireNonNull(circuitBreakerRegistry);
    }

    private void addMetrics(MeterRegistry registry, CircuitBreaker circuitBreaker) {
        CircuitBreaker.State[] states;
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        for (CircuitBreaker.State state : states = CircuitBreaker.State.values()) {
            idSet.add(Gauge.builder((String)this.names.getStateMetricName(), (Object)circuitBreaker, cb -> cb.getState() == state ? 1.0 : 0.0).description("The states of the circuit breaker").tag("name", circuitBreaker.getName()).tag(KIND_STATE, state.name().toLowerCase()).register(registry).getId());
        }
        idSet.add(Gauge.builder((String)this.names.getBufferedCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfFailedCalls()).description("The number of buffered failed calls stored in the ring buffer").tag("name", circuitBreaker.getName()).tag("kind", KIND_FAILED).register(registry).getId());
        idSet.add(Gauge.builder((String)this.names.getBufferedCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfSuccessfulCalls()).description("The number of buffered successful calls stored in the ring buffer").tag("name", circuitBreaker.getName()).tag("kind", KIND_SUCCESSFUL).register(registry).getId());
        idSet.add(Gauge.builder((String)this.names.getMaxBufferedCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getMaxNumberOfBufferedCalls()).description("The maximum number of buffered calls which can be stored in the ring buffer").tag("name", circuitBreaker.getName()).register(registry).getId());
        idSet.add(Gauge.builder((String)this.names.getFailureRateMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getFailureRate()).description("The failure rate of the circuit breaker").tag("name", circuitBreaker.getName()).register(registry).getId());
        Timer successfulCalls = Timer.builder((String)this.names.getCallsMetricName()).description("Total number of successful calls").tag("name", circuitBreaker.getName()).tag("kind", KIND_SUCCESSFUL).register(registry);
        Timer failedCalls = Timer.builder((String)this.names.getCallsMetricName()).description("Total number of failed calls").tag("name", circuitBreaker.getName()).tag("kind", KIND_FAILED).register(registry);
        Timer ignoredFailedCalls = Timer.builder((String)this.names.getCallsMetricName()).description("Total number of calls which failed but the exception was ignored").tag("name", circuitBreaker.getName()).tag("kind", KIND_IGNORED).register(registry);
        Counter notPermittedCalls = Counter.builder((String)this.names.getCallsMetricName()).description("Total number of not permitted calls").tag("name", circuitBreaker.getName()).tag("kind", KIND_NOT_PERMITTED).register(registry);
        idSet.add(successfulCalls.getId());
        idSet.add(failedCalls.getId());
        idSet.add(ignoredFailedCalls.getId());
        idSet.add(notPermittedCalls.getId());
        circuitBreaker.getEventPublisher().onIgnoredError(event -> ignoredFailedCalls.record(event.getElapsedDuration())).onCallNotPermitted(event -> notPermittedCalls.increment()).onSuccess(event -> successfulCalls.record(event.getElapsedDuration())).onError(event -> failedCalls.record(event.getElapsedDuration()));
        this.meterIdMap.put(circuitBreaker.getName(), idSet);
    }

    public void bindTo(MeterRegistry registry) {
        for (CircuitBreaker circuitBreaker : this.circuitBreakerRegistry.getAllCircuitBreakers()) {
            this.addMetrics(registry, circuitBreaker);
        }
        this.circuitBreakerRegistry.getEventPublisher().onEntryAdded(event -> this.addMetrics(registry, (CircuitBreaker)event.getAddedEntry()));
        this.circuitBreakerRegistry.getEventPublisher().onEntryRemoved(event -> this.removeMetrics(registry, ((CircuitBreaker)event.getRemovedEntry()).getName()));
        this.circuitBreakerRegistry.getEventPublisher().onEntryReplaced(event -> {
            this.removeMetrics(registry, ((CircuitBreaker)event.getOldEntry()).getName());
            this.addMetrics(registry, (CircuitBreaker)event.getNewEntry());
        });
    }

    public static class MetricNames {
        private static final String DEFAULT_PREFIX = "resilience4j.circuitbreaker";
        public static final String DEFAULT_CIRCUIT_BREAKER_CALLS = "resilience4j.circuitbreaker.calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_STATE = "resilience4j.circuitbreaker.state";
        public static final String DEFAULT_CIRCUIT_BREAKER_BUFFERED_CALLS = "resilience4j.circuitbreaker.buffered.calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_MAX_BUFFERED_CALLS = "resilience4j.circuitbreaker.max.buffered.calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_FAILURE_RATE = "resilience4j.circuitbreaker.failure.rate";
        private String callsMetricName = "resilience4j.circuitbreaker.calls";
        private String stateMetricName = "resilience4j.circuitbreaker.state";
        private String bufferedCallsMetricName = "resilience4j.circuitbreaker.buffered.calls";
        private String maxBufferedCallsMetricName = "resilience4j.circuitbreaker.max.buffered.calls";
        private String failureRateMetricName = "resilience4j.circuitbreaker.failure.rate";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        private MetricNames() {
        }

        public String getCallsMetricName() {
            return this.callsMetricName;
        }

        public String getBufferedCallsMetricName() {
            return this.bufferedCallsMetricName;
        }

        public String getMaxBufferedCallsMetricName() {
            return this.maxBufferedCallsMetricName;
        }

        public String getStateMetricName() {
            return this.stateMetricName;
        }

        public String getFailureRateMetricName() {
            return this.failureRateMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder callsMetricName(String callsMetricName) {
                this.metricNames.callsMetricName = Objects.requireNonNull(callsMetricName);
                return this;
            }

            public Builder stateMetricName(String stateMetricName) {
                this.metricNames.stateMetricName = Objects.requireNonNull(stateMetricName);
                return this;
            }

            public Builder bufferedCallsMetricName(String bufferedCallsMetricName) {
                this.metricNames.bufferedCallsMetricName = Objects.requireNonNull(bufferedCallsMetricName);
                return this;
            }

            public Builder maxBufferedCallsMetricName(String maxBufferedCallsMetricName) {
                this.metricNames.maxBufferedCallsMetricName = Objects.requireNonNull(maxBufferedCallsMetricName);
                return this;
            }

            public Builder failureRateMetricName(String failureRateMetricName) {
                this.metricNames.failureRateMetricName = Objects.requireNonNull(failureRateMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

