/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

abstract class AbstractBulkheadMetrics
extends AbstractMetrics {
    protected final MetricNames names;

    protected AbstractBulkheadMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, Bulkhead bulkhead) {
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        List customTags = bulkhead.getTags().toJavaMap().entrySet().stream().map(tagsEntry -> Tag.of((String)((String)tagsEntry.getKey()), (String)((String)tagsEntry.getValue()))).collect(Collectors.toList());
        idSet.add(Gauge.builder((String)this.names.getAvailableConcurrentCallsMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getAvailableConcurrentCalls()).description("The number of available permissions").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getMaxAllowedConcurrentCallsMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getMaxAllowedConcurrentCalls()).description("The maximum number of available permissions").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        this.meterIdMap.put(bulkhead.getName(), idSet);
    }

    public static class MetricNames {
        private static final String DEFAULT_PREFIX = "resilience4j.bulkhead";
        public static final String DEFAULT_BULKHEAD_AVAILABLE_CONCURRENT_CALLS_METRIC_NAME = "resilience4j.bulkhead.available.concurrent.calls";
        public static final String DEFAULT_BULKHEAD_MAX_ALLOWED_CONCURRENT_CALLS_METRIC_NAME = "resilience4j.bulkhead.max.allowed.concurrent.calls";
        private String availableConcurrentCallsMetricName = "resilience4j.bulkhead.available.concurrent.calls";
        private String maxAllowedConcurrentCallsMetricName = "resilience4j.bulkhead.max.allowed.concurrent.calls";

        private MetricNames() {
        }

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getAvailableConcurrentCallsMetricName() {
            return this.availableConcurrentCallsMetricName;
        }

        public String getMaxAllowedConcurrentCallsMetricName() {
            return this.maxAllowedConcurrentCallsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder availableConcurrentCallsMetricName(String availableConcurrentCallsMetricName) {
                this.metricNames.availableConcurrentCallsMetricName = Objects.requireNonNull(availableConcurrentCallsMetricName);
                return this;
            }

            public Builder maxAllowedConcurrentCallsMetricName(String maxAllowedConcurrentCallsMetricName) {
                this.metricNames.maxAllowedConcurrentCallsMetricName = Objects.requireNonNull(maxAllowedConcurrentCallsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

