/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

abstract class AbstractCircuitBreakerMetrics
extends AbstractMetrics {
    private static final String KIND_STATE = "state";
    private static final String KIND_FAILED = "failed";
    private static final String KIND_SUCCESSFUL = "successful";
    private static final String KIND_IGNORED = "ignored";
    private static final String KIND_NOT_PERMITTED = "not_permitted";
    protected final MetricNames names;

    protected AbstractCircuitBreakerMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, CircuitBreaker circuitBreaker) {
        CircuitBreaker.State[] states;
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        List customTags = circuitBreaker.getTags().toJavaMap().entrySet().stream().map(tagsEntry -> Tag.of((String)((String)tagsEntry.getKey()), (String)((String)tagsEntry.getValue()))).collect(Collectors.toList());
        for (CircuitBreaker.State state : states = CircuitBreaker.State.values()) {
            idSet.add(Gauge.builder((String)this.names.getStateMetricName(), (Object)circuitBreaker, cb -> cb.getState() == state ? 1.0 : 0.0).description("The states of the circuit breaker").tag("name", circuitBreaker.getName()).tag(KIND_STATE, state.name().toLowerCase()).tags(customTags).register(meterRegistry).getId());
        }
        idSet.add(Gauge.builder((String)this.names.getBufferedCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfFailedCalls()).description("The number of buffered failed calls stored in the ring buffer").tag("name", circuitBreaker.getName()).tag("kind", KIND_FAILED).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getBufferedCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfSuccessfulCalls()).description("The number of buffered successful calls stored in the ring buffer").tag("name", circuitBreaker.getName()).tag("kind", KIND_SUCCESSFUL).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getSlowCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfSlowSuccessfulCalls()).description("The number of slow successful which were slower than a certain threshold").tag("name", circuitBreaker.getName()).tag("kind", KIND_SUCCESSFUL).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getSlowCallsMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getNumberOfSlowFailedCalls()).description("The number of slow failed calls which were slower than a certain threshold").tag("name", circuitBreaker.getName()).tag("kind", KIND_FAILED).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getFailureRateMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getFailureRate()).description("The failure rate of the circuit breaker").tag("name", circuitBreaker.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getSlowCallRateMetricName(), (Object)circuitBreaker, cb -> cb.getMetrics().getSlowCallRate()).description("The slow call of the circuit breaker").tag("name", circuitBreaker.getName()).tags(customTags).register(meterRegistry).getId());
        Timer successfulCalls = Timer.builder((String)this.names.getCallsMetricName()).description("Total number of successful calls").tag("name", circuitBreaker.getName()).tag("kind", KIND_SUCCESSFUL).tags(customTags).register(meterRegistry);
        Timer failedCalls = Timer.builder((String)this.names.getCallsMetricName()).description("Total number of failed calls").tag("name", circuitBreaker.getName()).tag("kind", KIND_FAILED).tags(customTags).register(meterRegistry);
        Timer ignoredFailedCalls = Timer.builder((String)this.names.getCallsMetricName()).description("Total number of calls which failed but the exception was ignored").tag("name", circuitBreaker.getName()).tag("kind", KIND_IGNORED).tags(customTags).register(meterRegistry);
        Counter notPermittedCalls = Counter.builder((String)this.names.getCallsMetricName()).description("Total number of not permitted calls").tag("name", circuitBreaker.getName()).tag("kind", KIND_NOT_PERMITTED).tags(customTags).register(meterRegistry);
        idSet.add(successfulCalls.getId());
        idSet.add(failedCalls.getId());
        idSet.add(ignoredFailedCalls.getId());
        idSet.add(notPermittedCalls.getId());
        circuitBreaker.getEventPublisher().onIgnoredError(event -> ignoredFailedCalls.record(event.getElapsedDuration())).onCallNotPermitted(event -> notPermittedCalls.increment()).onSuccess(event -> successfulCalls.record(event.getElapsedDuration())).onError(event -> failedCalls.record(event.getElapsedDuration()));
        this.meterIdMap.put(circuitBreaker.getName(), idSet);
    }

    public static class MetricNames {
        private static final String DEFAULT_PREFIX = "resilience4j.circuitbreaker";
        public static final String DEFAULT_CIRCUIT_BREAKER_CALLS = "resilience4j.circuitbreaker.calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_STATE = "resilience4j.circuitbreaker.state";
        public static final String DEFAULT_CIRCUIT_BREAKER_BUFFERED_CALLS = "resilience4j.circuitbreaker.buffered.calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_SLOW_CALLS = "resilience4j.circuitbreaker.slow.calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_FAILURE_RATE = "resilience4j.circuitbreaker.failure.rate";
        public static final String DEFAULT_CIRCUIT_BREAKER_SLOW_CALL_RATE = "resilience4j.circuitbreaker.slow.call.rate";
        private String callsMetricName = "resilience4j.circuitbreaker.calls";
        private String stateMetricName = "resilience4j.circuitbreaker.state";
        private String bufferedCallsMetricName = "resilience4j.circuitbreaker.buffered.calls";
        private String slowCallsMetricName = "resilience4j.circuitbreaker.slow.calls";
        private String failureRateMetricName = "resilience4j.circuitbreaker.failure.rate";
        private String slowCallRateMetricName = "resilience4j.circuitbreaker.slow.call.rate";

        private MetricNames() {
        }

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getCallsMetricName() {
            return this.callsMetricName;
        }

        public String getBufferedCallsMetricName() {
            return this.bufferedCallsMetricName;
        }

        public String getSlowCallsMetricName() {
            return this.slowCallsMetricName;
        }

        public String getStateMetricName() {
            return this.stateMetricName;
        }

        public String getFailureRateMetricName() {
            return this.failureRateMetricName;
        }

        public String getSlowCallRateMetricName() {
            return this.slowCallRateMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder callsMetricName(String callsMetricName) {
                this.metricNames.callsMetricName = Objects.requireNonNull(callsMetricName);
                return this;
            }

            public Builder stateMetricName(String stateMetricName) {
                this.metricNames.stateMetricName = Objects.requireNonNull(stateMetricName);
                return this;
            }

            public Builder bufferedCallsMetricName(String bufferedCallsMetricName) {
                this.metricNames.bufferedCallsMetricName = Objects.requireNonNull(bufferedCallsMetricName);
                return this;
            }

            public Builder slowCallsMetricName(String slowCallsMetricName) {
                this.metricNames.slowCallsMetricName = Objects.requireNonNull(slowCallsMetricName);
                return this;
            }

            public Builder failureRateMetricName(String failureRateMetricName) {
                this.metricNames.failureRateMetricName = Objects.requireNonNull(failureRateMetricName);
                return this;
            }

            public Builder slowCallRateMetricName(String slowCallRateMetricName) {
                this.metricNames.slowCallRateMetricName = Objects.requireNonNull(slowCallRateMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

