/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

abstract class AbstractThreadPoolBulkheadMetrics
extends AbstractMetrics {
    protected final MetricNames names;

    protected AbstractThreadPoolBulkheadMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
    }

    protected void addMetrics(MeterRegistry meterRegistry, ThreadPoolBulkhead bulkhead) {
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        List customTags = bulkhead.getTags().toJavaMap().entrySet().stream().map(tagsEntry -> Tag.of((String)((String)tagsEntry.getKey()), (String)((String)tagsEntry.getValue()))).collect(Collectors.toList());
        idSet.add(Gauge.builder((String)this.names.getQueueDepthMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getQueueDepth()).description("The queue depth").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getThreadPoolSizeMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getThreadPoolSize()).description("The thread pool size").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getQueueCapacityMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getQueueCapacity()).description("The queue capacity").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getMaxThreadPoolSizeMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getMaximumThreadPoolSize()).description("The maximum thread pool size").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        idSet.add(Gauge.builder((String)this.names.getCoreThreadPoolSizeMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getCoreThreadPoolSize()).description("The core thread pool size").tag("name", bulkhead.getName()).tags(customTags).register(meterRegistry).getId());
        this.meterIdMap.put(bulkhead.getName(), idSet);
    }

    public static class MetricNames {
        private static final String DEFAULT_PREFIX = "resilience4j.bulkhead";
        public static final String DEFAULT_BULKHEAD_QUEUE_DEPTH_METRIC_NAME = "resilience4j.bulkhead.queue.depth";
        public static final String DEFAULT_BULKHEAD_QUEUE_CAPACITY_METRIC_NAME = "resilience4j.bulkhead.queue.capacity";
        public static final String DEFAULT_THREAD_POOL_SIZE_METRIC_NAME = "resilience4j.bulkhead.thread.pool.size";
        public static final String DEFAULT_MAX_THREAD_POOL_SIZE_METRIC_NAME = "resilience4j.bulkhead.max.thread.pool.size";
        public static final String DEFAULT_CORE_THREAD_POOL_SIZE_METRIC_NAME = "resilience4j.bulkhead.core.thread.pool.size";
        private String queueDepthMetricName = "resilience4j.bulkhead.queue.depth";
        private String threadPoolSizeMetricName = "resilience4j.bulkhead.thread.pool.size";
        private String maxThreadPoolSizeMetricName = "resilience4j.bulkhead.max.thread.pool.size";
        private String coreThreadPoolSizeMetricName = "resilience4j.bulkhead.core.thread.pool.size";
        private String queueCapacityMetricName = "resilience4j.bulkhead.queue.capacity";

        private MetricNames() {
        }

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getQueueDepthMetricName() {
            return this.queueDepthMetricName;
        }

        public String getThreadPoolSizeMetricName() {
            return this.threadPoolSizeMetricName;
        }

        public String getMaxThreadPoolSizeMetricName() {
            return this.maxThreadPoolSizeMetricName;
        }

        public String getCoreThreadPoolSizeMetricName() {
            return this.coreThreadPoolSizeMetricName;
        }

        public String getQueueCapacityMetricName() {
            return this.queueCapacityMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder queueDepthMetricName(String queueDepthMetricName) {
                this.metricNames.queueDepthMetricName = Objects.requireNonNull(queueDepthMetricName);
                return this;
            }

            public Builder threadPoolSizeMetricName(String threadPoolSizeMetricName) {
                this.metricNames.threadPoolSizeMetricName = Objects.requireNonNull(threadPoolSizeMetricName);
                return this;
            }

            public Builder maxThreadPoolSizeMetricName(String maxThreadPoolSizeMetricName) {
                this.metricNames.maxThreadPoolSizeMetricName = Objects.requireNonNull(maxThreadPoolSizeMetricName);
                return this;
            }

            public Builder coreThreadPoolSizeMetricName(String coreThreadPoolSizeMetricName) {
                this.metricNames.coreThreadPoolSizeMetricName = Objects.requireNonNull(coreThreadPoolSizeMetricName);
                return this;
            }

            public Builder queueCapacityMetricName(String queueCapacityMetricName) {
                this.metricNames.queueCapacityMetricName = Objects.requireNonNull(queueCapacityMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

