/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.micrometer.tagged.AbstractRateLimiterMetrics;
import io.github.resilience4j.micrometer.tagged.RateLimiterMetricNames;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;

public class TaggedRateLimiterMetrics
extends AbstractRateLimiterMetrics
implements MeterBinder {
    private final RateLimiterRegistry rateLimiterRegistry;

    private TaggedRateLimiterMetrics(RateLimiterMetricNames names, RateLimiterRegistry rateLimiterRegistry) {
        super(names);
        this.rateLimiterRegistry = Objects.requireNonNull(rateLimiterRegistry);
    }

    public static TaggedRateLimiterMetrics ofRateLimiterRegistry(RateLimiterRegistry rateLimiterRegistry) {
        return new TaggedRateLimiterMetrics(RateLimiterMetricNames.ofDefaults(), rateLimiterRegistry);
    }

    public static TaggedRateLimiterMetrics ofRateLimiterRegistry(RateLimiterMetricNames names, RateLimiterRegistry rateLimiterRegistry) {
        return new TaggedRateLimiterMetrics(names, rateLimiterRegistry);
    }

    public void bindTo(MeterRegistry registry) {
        for (RateLimiter rateLimiter : this.rateLimiterRegistry.getAllRateLimiters()) {
            this.addMetrics(registry, rateLimiter);
        }
        this.rateLimiterRegistry.getEventPublisher().onEntryAdded(event -> this.addMetrics(registry, (RateLimiter)event.getAddedEntry()));
        this.rateLimiterRegistry.getEventPublisher().onEntryRemoved(event -> this.removeMetrics(registry, ((RateLimiter)event.getRemovedEntry()).getName()));
        this.rateLimiterRegistry.getEventPublisher().onEntryReplaced(event -> {
            this.removeMetrics(registry, ((RateLimiter)event.getOldEntry()).getName());
            this.addMetrics(registry, (RateLimiter)event.getNewEntry());
        });
    }
}

