/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.discovery.exceptions.NoAvailableServiceException;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.retry.exception.FallbackException;
import io.reactivex.Flowable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(BaseInterceptor.class);

    public abstract Optional<? extends MethodExecutionHandle<?, Object>> findFallbackMethod(MethodInvocationContext<Object, Object> var1);

    public Object fallback(MethodInvocationContext<Object, Object> context, Throwable exception) {
        if (exception instanceof NoAvailableServiceException) {
            NoAvailableServiceException ex = (NoAvailableServiceException)exception;
            if (logger.isErrorEnabled()) {
                logger.debug(ex.getMessage(), (Throwable)ex);
                logger.error("Type [{}] attempting to resolve fallback for unavailable service [{}]", (Object)context.getTarget().getClass().getName(), (Object)ex.getServiceID());
            }
        } else if (logger.isErrorEnabled()) {
            logger.error("Type [{}]  executed with error: {}", new Object[]{context.getTarget().getClass().getName(), exception.getMessage(), exception});
        }
        Optional<MethodExecutionHandle<?, Object>> fallback = this.findFallbackMethod(context);
        if (fallback.isPresent()) {
            MethodExecutionHandle<?, Object> fallbackMethod = fallback.get();
            if (logger.isDebugEnabled()) {
                logger.debug("Type [{}] resolved fallback: {}", (Object)context.getTarget().getClass().getName(), fallbackMethod);
            }
            return fallbackMethod.invoke(context.getParameterValues());
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new CompletionException(exception);
    }

    public CompletionStage<?> fallbackForFuture(CompletionStage<?> result, MethodInvocationContext<Object, Object> context) {
        CompletableFuture newFuture = new CompletableFuture();
        result.whenComplete((o, throwable) -> {
            block9: {
                if (throwable == null) {
                    newFuture.complete(o);
                } else {
                    Optional<MethodExecutionHandle<?, Object>> fallbackMethod = this.findFallbackMethod(context);
                    if (fallbackMethod.isPresent()) {
                        MethodExecutionHandle<?, Object> fallbackHandle = fallbackMethod.get();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Type [{}] resolved fallback: {}", context.getTarget().getClass(), fallbackHandle);
                        }
                        try {
                            CompletableFuture resultingFuture = (CompletableFuture)fallbackHandle.invoke(context.getParameterValues());
                            if (resultingFuture == null) {
                                newFuture.completeExceptionally((Throwable)new FallbackException("Fallback handler [" + fallbackHandle + "] returned null value"));
                                break block9;
                            }
                            resultingFuture.whenComplete((o1, throwable1) -> {
                                if (throwable1 == null) {
                                    newFuture.complete(o1);
                                } else {
                                    newFuture.completeExceptionally((Throwable)throwable1);
                                }
                            });
                        }
                        catch (Exception e) {
                            if (logger.isErrorEnabled()) {
                                logger.error("Error invoking Fallback [{}]: ", fallbackHandle, (Object)e);
                            }
                            newFuture.completeExceptionally((Throwable)throwable);
                        }
                    } else {
                        newFuture.completeExceptionally((Throwable)throwable);
                    }
                }
            }
        });
        return newFuture;
    }

    public <T> Publisher<T> fallbackReactiveTypes(Publisher<T> flowable, MethodInvocationContext<Object, Object> context) {
        return Flowable.fromPublisher(flowable).onErrorResumeNext(throwable -> {
            Optional<MethodExecutionHandle<?, Object>> fallbackMethod = this.findFallbackMethod(context);
            if (fallbackMethod.isPresent()) {
                Object fallbackResult;
                MethodExecutionHandle<?, Object> fallbackHandle = fallbackMethod.get();
                if (logger.isDebugEnabled()) {
                    logger.debug("Type [{}] resolved fallback: {}", context.getTarget().getClass(), fallbackHandle);
                }
                try {
                    fallbackResult = fallbackHandle.invoke(context.getParameterValues());
                }
                catch (Exception e) {
                    return Flowable.error((Throwable)throwable);
                }
                if (fallbackResult == null) {
                    return Flowable.error((Throwable)new FallbackException("Fallback handler [" + fallbackHandle + "] returned null value"));
                }
                return (Publisher)ConversionService.SHARED.convert(fallbackResult, Publisher.class).orElseThrow(() -> new FallbackException("Unsupported Reactive type: " + fallbackResult));
            }
            return Flowable.error((Throwable)throwable);
        });
    }
}

