/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.bulkhead;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.bulkhead.configuration.BulkheadConfigCustomizer;
import io.github.resilience4j.common.bulkhead.configuration.BulkheadConfigurationProperties;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.micronaut.bulkhead.BulkheadProperties;
import io.github.resilience4j.micronaut.bulkhead.BulkheadQualifier;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Factory
@Requires(property="resilience4j.bulkhead.enabled", value="true", defaultValue="false")
public class BulkHeadRegistryFactory {
    @Bean
    @BulkheadQualifier
    public CompositeCustomizer<BulkheadConfigCustomizer> composeBulkheadCustomizer(@Nullable List<BulkheadConfigCustomizer> configCustomizers) {
        return new CompositeCustomizer(configCustomizers);
    }

    @Singleton
    @Requires(beans={BulkheadProperties.class})
    public BulkheadRegistry bulkheadRegistry(BulkheadConfigurationProperties bulkheadConfigurationProperties, @BulkheadQualifier EventConsumerRegistry<BulkheadEvent> bulkheadEventConsumerRegistry, @BulkheadQualifier RegistryEventConsumer<Bulkhead> bulkheadRegistryEventConsumer, @BulkheadQualifier CompositeCustomizer<BulkheadConfigCustomizer> compositeBulkheadCustomizer) {
        BulkheadRegistry bulkheadRegistry = this.createBulkheadRegistry(bulkheadConfigurationProperties, bulkheadRegistryEventConsumer, compositeBulkheadCustomizer);
        this.registerEventConsumer(bulkheadRegistry, bulkheadEventConsumerRegistry, bulkheadConfigurationProperties);
        bulkheadConfigurationProperties.getInstances().forEach((name, properties) -> bulkheadRegistry.bulkhead(name, bulkheadConfigurationProperties.createBulkheadConfig(properties, compositeBulkheadCustomizer, name)));
        return bulkheadRegistry;
    }

    @Bean
    @Primary
    @BulkheadQualifier
    public RegistryEventConsumer<Bulkhead> bulkheadRegistryEventConsumer(Optional<List<RegistryEventConsumer<Bulkhead>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    @Bean
    @BulkheadQualifier
    public EventConsumerRegistry<BulkheadEvent> bulkheadEventsConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    private void registerEventConsumer(BulkheadRegistry bulkheadRegistry, EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry, BulkheadConfigurationProperties bulkheadConfigurationProperties) {
        bulkheadRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (Bulkhead)event.getAddedEntry(), bulkheadConfigurationProperties));
    }

    private void registerEventConsumer(EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry, Bulkhead bulkHead, BulkheadConfigurationProperties bulkheadConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(bulkheadConfigurationProperties.getBackendProperties(bulkHead.getName())).map(BulkheadConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        bulkHead.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(bulkHead.getName(), eventConsumerBufferSize));
    }

    private BulkheadRegistry createBulkheadRegistry(BulkheadConfigurationProperties bulkheadConfigurationProperties, RegistryEventConsumer<Bulkhead> bulkheadRegistryEventConsumer, CompositeCustomizer<BulkheadConfigCustomizer> compositeBulkheadCustomizer) {
        java.util.Map<String, BulkheadConfig> configs = bulkheadConfigurationProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> bulkheadConfigurationProperties.createBulkheadConfig((BulkheadConfigurationProperties.InstanceProperties)entry.getValue(), compositeBulkheadCustomizer, (String)entry.getKey())));
        return BulkheadRegistry.of(configs, bulkheadRegistryEventConsumer, (Map)HashMap.ofAll((java.util.Map)bulkheadConfigurationProperties.getTags()));
    }
}

