/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.bulkhead;

import io.github.resilience4j.common.bulkhead.configuration.BulkheadConfigurationProperties;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.Toggleable;
import java.util.List;

@ConfigurationProperties(value="resilience4j.bulkhead")
public class BulkheadProperties
extends BulkheadConfigurationProperties
implements Toggleable {
    private boolean enabled;

    public BulkheadProperties(List<InstancePropertiesConfigs> configs, List<InstancePropertiesInstances> instances) {
        for (InstancePropertiesConfigs config : configs) {
            this.getConfigs().put(config.getName(), config);
        }
        for (InstancePropertiesInstances instance : instances) {
            this.getInstances().put(instance.getName(), instance);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @EachProperty(value="configs", primary="default")
    public static class InstancePropertiesConfigs
    extends BulkheadConfigurationProperties.InstanceProperties
    implements Named {
        private final String name;

        public InstancePropertiesConfigs(@Parameter String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    @EachProperty(value="instances", primary="default")
    public static class InstancePropertiesInstances
    extends BulkheadConfigurationProperties.InstanceProperties
    implements Named {
        private final String name;

        public InstancePropertiesInstances(@Parameter String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

