/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.retry;

import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.retry.configuration.RetryConfigCustomizer;
import io.github.resilience4j.common.retry.configuration.RetryConfigurationProperties;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.micronaut.retry.RetryQualifier;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.event.RetryEvent;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Factory
@Requires(property="resilience4j.retry.enabled", value="true", defaultValue="false")
public class RetryRegistryFactory {
    @Bean
    @RetryQualifier
    public CompositeCustomizer<RetryConfigCustomizer> compositeTimeLimiterCustomizer(@Nullable List<RetryConfigCustomizer> configCustomizers) {
        return new CompositeCustomizer(configCustomizers);
    }

    @Singleton
    @Requires(beans={RetryConfigurationProperties.class})
    public RetryRegistry createRetryRegistry(RetryConfigurationProperties retryConfigurationProperties, @RetryQualifier EventConsumerRegistry<RetryEvent> retryEventConsumerRegistry, @RetryQualifier RegistryEventConsumer<Retry> retryRegistryEventConsumer, @RetryQualifier CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer) {
        RetryRegistry retryRegistry = this.createRetryRegistry(retryConfigurationProperties, retryRegistryEventConsumer, compositeRetryCustomizer);
        this.registerEventConsumer(retryRegistry, retryEventConsumerRegistry, retryConfigurationProperties);
        retryConfigurationProperties.getInstances().forEach((name, properties) -> retryRegistry.retry(name, retryConfigurationProperties.createRetryConfig(name, compositeRetryCustomizer)));
        return retryRegistry;
    }

    @Bean
    @RetryQualifier
    public EventConsumerRegistry<RetryEvent> retryEventEventConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    @Bean
    @Primary
    @RetryQualifier
    public RegistryEventConsumer<Retry> retryRegistryEventConsumer(Optional<List<RegistryEventConsumer<Retry>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    private void registerEventConsumer(RetryRegistry retryRegistry, EventConsumerRegistry<RetryEvent> eventConsumerRegistry, RetryConfigurationProperties rateLimiterConfigurationProperties) {
        retryRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (Retry)event.getAddedEntry(), rateLimiterConfigurationProperties));
    }

    private void registerEventConsumer(EventConsumerRegistry<RetryEvent> eventConsumerRegistry, Retry retry, RetryConfigurationProperties retryConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(retryConfigurationProperties.getBackendProperties(retry.getName())).map(RetryConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        retry.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(retry.getName(), eventConsumerBufferSize));
    }

    private RetryRegistry createRetryRegistry(RetryConfigurationProperties retryProperties, RegistryEventConsumer<Retry> rateLimiterRegistryEventConsumer, CompositeCustomizer<RetryConfigCustomizer> compositeRateLimiterCustomizer) {
        java.util.Map<String, RetryConfig> configs = retryProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> retryProperties.createRetryConfig((RetryConfigurationProperties.InstanceProperties)entry.getValue(), compositeRateLimiterCustomizer, (String)entry.getKey())));
        return RetryRegistry.of(configs, rateLimiterRegistryEventConsumer, (Map)HashMap.ofAll((java.util.Map)retryProperties.getTags()));
    }
}

