/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.timelimiter;

import io.github.resilience4j.micronaut.BaseInterceptor;
import io.github.resilience4j.micronaut.ResilienceInterceptPhase;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.github.resilience4j.timelimiter.transformer.TimeLimiterTransformer;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.annotation.Requires;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
@Requires(beans={TimeLimiterRegistry.class})
public class TimeLimiterInterceptor
extends BaseInterceptor
implements MethodInterceptor<Object, Object> {
    private final TimeLimiterRegistry timeLimiterRegistry;
    private final ExecutionHandleLocator executionHandleLocator;
    private final ScheduledExecutorService executorService;

    public TimeLimiterInterceptor(ExecutionHandleLocator executionHandleLocator, TimeLimiterRegistry timeLimiterRegistry, @Named(value="scheduled") ExecutorService executorService) {
        this.executionHandleLocator = executionHandleLocator;
        this.timeLimiterRegistry = timeLimiterRegistry;
        this.executorService = (ScheduledExecutorService)executorService;
    }

    public int getOrder() {
        return ResilienceInterceptPhase.TIME_LIMITER.getPosition();
    }

    @Override
    public Optional<? extends MethodExecutionHandle<?, Object>> findFallbackMethod(MethodInvocationContext<Object, Object> context) {
        ExecutableMethod executableMethod = context.getExecutableMethod();
        String fallbackMethod = executableMethod.stringValue(io.github.resilience4j.micronaut.annotation.TimeLimiter.class, "fallbackMethod").orElse("");
        Class declaringType = context.getDeclaringType();
        return this.executionHandleLocator.findExecutionHandle(declaringType, fallbackMethod, context.getArgumentTypes());
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Optional opt = context.findAnnotation(io.github.resilience4j.micronaut.annotation.TimeLimiter.class);
        if (!opt.isPresent()) {
            return context.proceed();
        }
        ExecutableMethod executableMethod = context.getExecutableMethod();
        String name = executableMethod.stringValue(io.github.resilience4j.micronaut.annotation.TimeLimiter.class).orElse("default");
        TimeLimiter timeLimiter = this.timeLimiterRegistry.timeLimiter(name);
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context);
        try {
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    return interceptedMethod.handleResult(this.fallbackReactiveTypes(Flowable.fromPublisher((Publisher)interceptedMethod.interceptResultAsPublisher()).compose((FlowableTransformer)TimeLimiterTransformer.of((TimeLimiter)timeLimiter)), context));
                }
                case COMPLETION_STAGE: {
                    return interceptedMethod.handleResult(this.fallbackForFuture(timeLimiter.executeCompletionStage(this.executorService, () -> {
                        try {
                            return interceptedMethod.interceptResultAsCompletionStage();
                        }
                        catch (Exception e) {
                            throw new CompletionException(e);
                        }
                    }), context));
                }
                case SYNCHRONOUS: {
                    try {
                        return timeLimiter.executeFutureSupplier(() -> CompletableFuture.supplyAsync(() -> ((MethodInvocationContext)context).proceed()));
                    }
                    catch (Throwable exception) {
                        return this.fallback(context, exception);
                    }
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }
}

