/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.bulkhead;

import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.bulkhead.ThreadPoolBulkhead;
import io.github.resilience4j.bulkhead.ThreadPoolBulkheadRegistry;
import io.github.resilience4j.micronaut.BaseInterceptor;
import io.github.resilience4j.micronaut.ResilienceInterceptPhase;
import io.github.resilience4j.micronaut.annotation.Bulkhead;
import io.github.resilience4j.micronaut.util.PublisherExtension;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

@InterceptorBean(value={Bulkhead.class})
@Requires(beans={BulkheadRegistry.class, ThreadPoolBulkheadRegistry.class})
public class BulkheadInterceptor
extends BaseInterceptor
implements MethodInterceptor<Object, Object> {
    private final BulkheadRegistry bulkheadRegistry;
    private final ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry;
    private final ExecutionHandleLocator executionHandleLocator;
    private final PublisherExtension extension;
    private final ConversionService conversionService;

    public BulkheadInterceptor(BeanContext executionHandleLocator, BulkheadRegistry bulkheadRegistry, ThreadPoolBulkheadRegistry threadPoolBulkheadRegistry, PublisherExtension extension, ConversionService conversionService) {
        this.bulkheadRegistry = bulkheadRegistry;
        this.executionHandleLocator = executionHandleLocator;
        this.threadPoolBulkheadRegistry = threadPoolBulkheadRegistry;
        this.extension = extension;
        this.conversionService = conversionService;
    }

    public int getOrder() {
        return ResilienceInterceptPhase.BULKHEAD.getPosition();
    }

    @Override
    public Optional<? extends MethodExecutionHandle<?, Object>> findFallbackMethod(MethodInvocationContext<Object, Object> context) {
        ExecutableMethod executableMethod = context.getExecutableMethod();
        String fallbackMethod = executableMethod.stringValue(Bulkhead.class, "fallbackMethod").orElse("");
        Class declaringType = context.getDeclaringType();
        return this.executionHandleLocator.findExecutionHandle(declaringType, fallbackMethod, context.getArgumentTypes());
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        AnnotationValue bulkheadAnnotationValue = context.findAnnotation(Bulkhead.class).orElse(null);
        if (bulkheadAnnotationValue == null) {
            return context.proceed();
        }
        Bulkhead.Type type = bulkheadAnnotationValue.enumValue("type", Bulkhead.Type.class).orElse(Bulkhead.Type.SEMAPHORE);
        if (type == Bulkhead.Type.THREADPOOL) {
            return this.handleThreadPoolBulkhead(context, (AnnotationValue<Bulkhead>)bulkheadAnnotationValue);
        }
        String name = bulkheadAnnotationValue.stringValue("name").orElse("default");
        io.github.resilience4j.bulkhead.Bulkhead bulkhead = this.bulkheadRegistry.bulkhead(name);
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        try {
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    return interceptedMethod.handleResult(this.extension.fallbackPublisher(this.extension.bulkhead(interceptedMethod.interceptResultAsPublisher(), bulkhead), context, this::findFallbackMethod));
                }
                case COMPLETION_STAGE: {
                    return interceptedMethod.handleResult(this.fallbackForFuture(bulkhead.executeCompletionStage(() -> {
                        try {
                            return interceptedMethod.interceptResultAsCompletionStage();
                        }
                        catch (Exception e) {
                            throw new CompletionException(e);
                        }
                    }), context));
                }
                case SYNCHRONOUS: {
                    try {
                        return bulkhead.executeCheckedSupplier(() -> context.proceed());
                    }
                    catch (Throwable exception) {
                        return this.fallback(context, exception);
                    }
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }

    private CompletionStage<?> handleThreadPoolBulkhead(MethodInvocationContext<Object, Object> context, AnnotationValue<Bulkhead> bulkheadAnnotationValue) {
        String name = bulkheadAnnotationValue.stringValue("name").orElse("default");
        ThreadPoolBulkhead bulkhead = this.threadPoolBulkheadRegistry.bulkhead(name);
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        if (interceptedMethod.resultType() == InterceptedMethod.ResultType.COMPLETION_STAGE) {
            try {
                return this.fallbackForFuture(bulkhead.executeCallable(() -> {
                    try {
                        return ((CompletableFuture)context.proceed()).get();
                    }
                    catch (ExecutionException e) {
                        throw new CompletionException(e.getCause());
                    }
                    catch (InterruptedException | CancellationException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new CompletionException(e);
                    }
                }), context);
            }
            catch (BulkheadFullException ex) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(ex);
                return future;
            }
        }
        throw new IllegalStateException("ThreadPool bulkhead is only applicable for completable futures");
    }
}

