/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.circuitbreaker;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.circuitbreaker.configuration.CircuitBreakerConfigCustomizer;
import io.github.resilience4j.common.circuitbreaker.configuration.CommonCircuitBreakerConfigurationProperties;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.micronaut.circuitbreaker.CircuitBreakerProperties;
import io.github.resilience4j.micronaut.circuitbreaker.CircuitBreakerQualifier;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Factory
@Requires(property="resilience4j.circuitbreaker.enabled", value="true", defaultValue="false")
public class CircuitBreakerRegistryFactory {
    @Bean
    @CircuitBreakerQualifier
    public CompositeCustomizer<CircuitBreakerConfigCustomizer> compositeCircuitBreakerCustomizer(@Nullable List<CircuitBreakerConfigCustomizer> configCustomizer) {
        return new CompositeCustomizer(configCustomizer);
    }

    @Singleton
    @Requires(beans={CircuitBreakerProperties.class})
    public CircuitBreakerRegistry circuitBreakerRegistry(CommonCircuitBreakerConfigurationProperties circuitBreakerConfigurationProperties, @CircuitBreakerQualifier EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry, @CircuitBreakerQualifier RegistryEventConsumer<CircuitBreaker> circuitBreakerRegistryEventConsumer, @CircuitBreakerQualifier CompositeCustomizer<CircuitBreakerConfigCustomizer> compositeCircuitBreakerCustomizer) {
        CircuitBreakerRegistry circuitBreakerRegistry = this.createCircuitBreakerRegistry(circuitBreakerConfigurationProperties, circuitBreakerRegistryEventConsumer, compositeCircuitBreakerCustomizer);
        this.registerEventConsumer(circuitBreakerConfigurationProperties, circuitBreakerRegistry, eventConsumerRegistry);
        this.initCircuitBreakerRegistry(circuitBreakerConfigurationProperties, circuitBreakerRegistry, compositeCircuitBreakerCustomizer);
        return circuitBreakerRegistry;
    }

    @Bean
    @Primary
    @CircuitBreakerQualifier
    public RegistryEventConsumer<CircuitBreaker> circuitBreakerRegistryEventConsumer(Optional<List<RegistryEventConsumer<CircuitBreaker>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    @Bean
    @CircuitBreakerQualifier
    public EventConsumerRegistry<CircuitBreakerEvent> circuitBreakerEventsConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    private void initCircuitBreakerRegistry(CommonCircuitBreakerConfigurationProperties circuitBreakerConfigurationProperties, CircuitBreakerRegistry circuitBreakerRegistry, CompositeCustomizer<CircuitBreakerConfigCustomizer> customizerMap) {
        circuitBreakerConfigurationProperties.getInstances().forEach((name, properties) -> circuitBreakerRegistry.circuitBreaker(name, circuitBreakerConfigurationProperties.createCircuitBreakerConfig(name, properties, customizerMap)));
    }

    CircuitBreakerRegistry createCircuitBreakerRegistry(CommonCircuitBreakerConfigurationProperties circuitBreakerProperties, RegistryEventConsumer<CircuitBreaker> circuitBreakerRegistryEventConsumer, CompositeCustomizer<CircuitBreakerConfigCustomizer> customizerMap) {
        Map<String, CircuitBreakerConfig> configs = circuitBreakerProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> circuitBreakerProperties.createCircuitBreakerConfig((String)entry.getKey(), (CommonCircuitBreakerConfigurationProperties.InstanceProperties)entry.getValue(), customizerMap)));
        return CircuitBreakerRegistry.of(configs, circuitBreakerRegistryEventConsumer, (Map)circuitBreakerProperties.getTags());
    }

    public void registerEventConsumer(CommonCircuitBreakerConfigurationProperties circuitBreakerProperties, CircuitBreakerRegistry circuitBreakerRegistry, EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry) {
        circuitBreakerRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(circuitBreakerProperties, eventConsumerRegistry, (CircuitBreaker)event.getAddedEntry()));
    }

    private void registerEventConsumer(CommonCircuitBreakerConfigurationProperties circuitBreakerRegistry, EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry, CircuitBreaker circuitBreaker) {
        int eventConsumerBufferSize = circuitBreakerRegistry.findCircuitBreakerProperties(circuitBreaker.getName()).map(CommonCircuitBreakerConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        circuitBreaker.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(circuitBreaker.getName(), eventConsumerBufferSize));
    }
}

