/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.timelimiter;

import io.github.resilience4j.common.timelimiter.configuration.CommonTimeLimiterConfigurationProperties;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.Toggleable;
import java.util.List;

@ConfigurationProperties(value="resilience4j.timelimiter")
public class TimeLimiterProperties
extends CommonTimeLimiterConfigurationProperties
implements Toggleable {
    private boolean enabled;

    public TimeLimiterProperties(List<InstancePropertiesConfigs> configs, List<InstancePropertiesInstances> instances) {
        for (InstancePropertiesConfigs config : configs) {
            this.getConfigs().put(config.getName(), config);
        }
        for (InstancePropertiesInstances instance : instances) {
            this.getInstances().put(instance.getName(), instance);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @EachProperty(value="configs", primary="default")
    public static class InstancePropertiesConfigs
    extends CommonTimeLimiterConfigurationProperties.InstanceProperties
    implements Named {
        private final String name;

        public InstancePropertiesConfigs(@Parameter String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    @EachProperty(value="instances", primary="default")
    public static class InstancePropertiesInstances
    extends CommonTimeLimiterConfigurationProperties.InstanceProperties
    implements Named {
        private final String name;

        public InstancePropertiesInstances(@Parameter String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

