/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.prometheus.collectors;

import io.github.resilience4j.prometheus.LabelNames;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RateLimiterMetricsCollector
extends Collector {
    private final MetricNames names;
    private final RateLimiterRegistry rateLimiterRegistry;

    private RateLimiterMetricsCollector(MetricNames names, RateLimiterRegistry rateLimiterRegistry) {
        this.names = Objects.requireNonNull(names);
        this.rateLimiterRegistry = Objects.requireNonNull(rateLimiterRegistry);
    }

    public static RateLimiterMetricsCollector ofRateLimiterRegistry(MetricNames names, RateLimiterRegistry rateLimiterRegistry) {
        return new RateLimiterMetricsCollector(names, rateLimiterRegistry);
    }

    public static RateLimiterMetricsCollector ofRateLimiterRegistry(RateLimiterRegistry rateLimiterRegistry) {
        return new RateLimiterMetricsCollector(MetricNames.ofDefaults(), rateLimiterRegistry);
    }

    public List<Collector.MetricFamilySamples> collect() {
        GaugeMetricFamily availablePermissionsFamily = new GaugeMetricFamily(this.names.getAvailablePermissionsMetricName(), "The number of available permissions", LabelNames.NAME);
        GaugeMetricFamily waitingThreadsFamily = new GaugeMetricFamily(this.names.getWaitingThreadsMetricName(), "The number of waiting threads", LabelNames.NAME);
        for (RateLimiter rateLimiter : this.rateLimiterRegistry.getAllRateLimiters()) {
            List<String> nameLabel = Collections.singletonList(rateLimiter.getName());
            availablePermissionsFamily.addMetric(nameLabel, (double)rateLimiter.getMetrics().getAvailablePermissions());
            waitingThreadsFamily.addMetric(nameLabel, (double)rateLimiter.getMetrics().getNumberOfWaitingThreads());
        }
        return Arrays.asList(availablePermissionsFamily, waitingThreadsFamily);
    }

    public static class MetricNames {
        public static final String DEFAULT_AVAILABLE_PERMISSIONS_METRIC_NAME = "resilience4j_ratelimiter_available_permissions";
        public static final String DEFAULT_WAITING_THREADS_METRIC_NAME = "resilience4j_ratelimiter_waiting_threads";
        private String availablePermissionsMetricName = "resilience4j_ratelimiter_available_permissions";
        private String waitingThreadsMetricName = "resilience4j_ratelimiter_waiting_threads";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getAvailablePermissionsMetricName() {
            return this.availablePermissionsMetricName;
        }

        public String getWaitingThreadsMetricName() {
            return this.waitingThreadsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder availablePermissionsMetricName(String availablePermissionsMetricName) {
                this.metricNames.availablePermissionsMetricName = Objects.requireNonNull(availablePermissionsMetricName);
                return this;
            }

            public Builder waitingThreadsMetricName(String waitingThreadsMetricName) {
                this.metricNames.waitingThreadsMetricName = Objects.requireNonNull(waitingThreadsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

