/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.prometheus.collectors;

import io.github.resilience4j.prometheus.AbstractTimeLimiterMetrics;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.Counter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TimeLimiterMetricsCollector
extends AbstractTimeLimiterMetrics {
    private final TimeLimiterRegistry timeLimiterRegistry;

    private TimeLimiterMetricsCollector(AbstractTimeLimiterMetrics.MetricNames names, TimeLimiterRegistry timeLimiterRegistry) {
        super(names);
        this.timeLimiterRegistry = Objects.requireNonNull(timeLimiterRegistry);
        this.timeLimiterRegistry.getAllTimeLimiters().forEach(this::addMetrics);
        this.timeLimiterRegistry.getEventPublisher().onEntryAdded(event -> this.addMetrics((TimeLimiter)event.getAddedEntry()));
    }

    public static TimeLimiterMetricsCollector ofTimeLimiterRegistry(AbstractTimeLimiterMetrics.MetricNames names, TimeLimiterRegistry timeLimiterRegistry) {
        return new TimeLimiterMetricsCollector(names, timeLimiterRegistry);
    }

    public static TimeLimiterMetricsCollector ofTimeLimiterRegistry(TimeLimiterRegistry timeLimiterRegistry) {
        return new TimeLimiterMetricsCollector(AbstractTimeLimiterMetrics.MetricNames.ofDefaults(), timeLimiterRegistry);
    }

    private void addMetrics(TimeLimiter timeLimiter) {
        String name = timeLimiter.getName();
        timeLimiter.getEventPublisher().onSuccess(event -> ((Counter.Child)this.callsCounter.labels(new String[]{name, "successful"})).inc()).onError(event -> ((Counter.Child)this.callsCounter.labels(new String[]{name, "failed"})).inc()).onTimeout(event -> ((Counter.Child)this.callsCounter.labels(new String[]{name, "timeout"})).inc());
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Collections.list(this.collectorRegistry.metricFamilySamples());
    }
}

