/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.internal;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnFailureEvent;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnSuccessEvent;
import io.github.resilience4j.ratelimiter.internal.RateLimiterEventProcessor;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class AtomicRateLimiter
implements RateLimiter {
    private static final long nanoTimeStart = System.nanoTime();
    private final String name;
    private final AtomicInteger waitingThreads;
    private final AtomicReference<State> state;
    private final RateLimiterEventProcessor eventProcessor;

    public AtomicRateLimiter(String name, RateLimiterConfig rateLimiterConfig) {
        this.name = name;
        this.waitingThreads = new AtomicInteger(0);
        this.state = new AtomicReference<State>(new State(rateLimiterConfig, 0L, rateLimiterConfig.getLimitForPeriod(), 0L));
        this.eventProcessor = new RateLimiterEventProcessor();
    }

    @Override
    public void changeTimeoutDuration(Duration timeoutDuration) {
        RateLimiterConfig newConfig = RateLimiterConfig.from(this.state.get().config).timeoutDuration(timeoutDuration).build();
        this.state.updateAndGet(currentState -> new State(newConfig, ((State)currentState).activeCycle, ((State)currentState).activePermissions, ((State)currentState).nanosToWait));
    }

    @Override
    public void changeLimitForPeriod(int limitForPeriod) {
        RateLimiterConfig newConfig = RateLimiterConfig.from(this.state.get().config).limitForPeriod(limitForPeriod).build();
        this.state.updateAndGet(currentState -> new State(newConfig, ((State)currentState).activeCycle, ((State)currentState).activePermissions, ((State)currentState).nanosToWait));
    }

    private long currentNanoTime() {
        return System.nanoTime() - nanoTimeStart;
    }

    @Override
    public boolean getPermission(Duration timeoutDuration) {
        long timeoutInNanos = timeoutDuration.toNanos();
        State modifiedState = this.updateStateWithBackOff(timeoutInNanos);
        boolean result = this.waitForPermissionIfNecessary(timeoutInNanos, modifiedState.nanosToWait);
        this.publishRateLimiterEvent(result);
        return result;
    }

    private State updateStateWithBackOff(long timeoutInNanos) {
        State next;
        State prev;
        while (!this.compareAndSet(prev = this.state.get(), next = this.calculateNextState(timeoutInNanos, prev))) {
        }
        return next;
    }

    private boolean compareAndSet(State current, State next) {
        if (this.state.compareAndSet(current, next)) {
            return true;
        }
        LockSupport.parkNanos(1L);
        return false;
    }

    private State calculateNextState(long timeoutInNanos, State activeState) {
        long cyclePeriodInNanos = activeState.config.getLimitRefreshPeriodInNanos();
        int permissionsPerCycle = activeState.config.getLimitForPeriod();
        long currentNanos = this.currentNanoTime();
        long currentCycle = currentNanos / cyclePeriodInNanos;
        long nextCycle = activeState.activeCycle;
        int nextPermissions = activeState.activePermissions;
        if (nextCycle != currentCycle) {
            long elapsedCycles = currentCycle - nextCycle;
            long accumulatedPermissions = elapsedCycles * (long)permissionsPerCycle;
            nextCycle = currentCycle;
            nextPermissions = (int)Long.min((long)nextPermissions + accumulatedPermissions, permissionsPerCycle);
        }
        long nextNanosToWait = this.nanosToWaitForPermission(cyclePeriodInNanos, permissionsPerCycle, nextPermissions, currentNanos, currentCycle);
        State nextState = this.reservePermissions(activeState.config, timeoutInNanos, nextCycle, nextPermissions, nextNanosToWait);
        return nextState;
    }

    private long nanosToWaitForPermission(long cyclePeriodInNanos, int permissionsPerCycle, int availablePermissions, long currentNanos, long currentCycle) {
        if (availablePermissions > 0) {
            return 0L;
        }
        long nextCycleTimeInNanos = (currentCycle + 1L) * cyclePeriodInNanos;
        long nanosToNextCycle = nextCycleTimeInNanos - currentNanos;
        int fullCyclesToWait = -availablePermissions / permissionsPerCycle;
        return (long)fullCyclesToWait * cyclePeriodInNanos + nanosToNextCycle;
    }

    private State reservePermissions(RateLimiterConfig config, long timeoutInNanos, long cycle, int permissions, long nanosToWait) {
        boolean canAcquireInTime = timeoutInNanos >= nanosToWait;
        int permissionsWithReservation = permissions;
        if (canAcquireInTime) {
            --permissionsWithReservation;
        }
        return new State(config, cycle, permissionsWithReservation, nanosToWait);
    }

    private boolean waitForPermissionIfNecessary(long timeoutInNanos, long nanosToWait) {
        boolean canAcquireInTime;
        boolean canAcquireImmediately = nanosToWait <= 0L;
        boolean bl = canAcquireInTime = timeoutInNanos >= nanosToWait;
        if (canAcquireImmediately) {
            return true;
        }
        if (canAcquireInTime) {
            return this.waitForPermission(nanosToWait);
        }
        this.waitForPermission(timeoutInNanos);
        return false;
    }

    private boolean waitForPermission(long nanosToWait) {
        this.waitingThreads.incrementAndGet();
        long deadline = this.currentNanoTime() + nanosToWait;
        boolean wasInterrupted = false;
        while (this.currentNanoTime() < deadline && !wasInterrupted) {
            long sleepBlockDuration = deadline - this.currentNanoTime();
            LockSupport.parkNanos(sleepBlockDuration);
            wasInterrupted = Thread.interrupted();
        }
        this.waitingThreads.decrementAndGet();
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return !wasInterrupted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RateLimiterConfig getRateLimiterConfig() {
        return this.state.get().config;
    }

    @Override
    public RateLimiter.Metrics getMetrics() {
        return new AtomicRateLimiterMetrics();
    }

    @Override
    public RateLimiter.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    public String toString() {
        return "AtomicRateLimiter{name='" + this.name + '\'' + ", rateLimiterConfig=" + this.state.get().config + '}';
    }

    public AtomicRateLimiterMetrics getDetailedMetrics() {
        return new AtomicRateLimiterMetrics();
    }

    private void publishRateLimiterEvent(boolean permissionAcquired) {
        if (!this.eventProcessor.hasConsumers()) {
            return;
        }
        if (permissionAcquired) {
            this.eventProcessor.consumeEvent(new RateLimiterOnSuccessEvent(this.name));
            return;
        }
        this.eventProcessor.consumeEvent(new RateLimiterOnFailureEvent(this.name));
    }

    public class AtomicRateLimiterMetrics
    implements RateLimiter.Metrics {
        private AtomicRateLimiterMetrics() {
        }

        @Override
        public int getNumberOfWaitingThreads() {
            return AtomicRateLimiter.this.waitingThreads.get();
        }

        @Override
        public int getAvailablePermissions() {
            State currentState = (State)AtomicRateLimiter.this.state.get();
            State estimatedState = AtomicRateLimiter.this.calculateNextState(-1L, currentState);
            return estimatedState.activePermissions;
        }

        public long getNanosToWait() {
            State currentState = (State)AtomicRateLimiter.this.state.get();
            State estimatedState = AtomicRateLimiter.this.calculateNextState(-1L, currentState);
            return estimatedState.nanosToWait;
        }

        public long getCycle() {
            State currentState = (State)AtomicRateLimiter.this.state.get();
            State estimatedState = AtomicRateLimiter.this.calculateNextState(-1L, currentState);
            return estimatedState.activeCycle;
        }
    }

    private static class State {
        private final RateLimiterConfig config;
        private final long activeCycle;
        private final int activePermissions;
        private final long nanosToWait;

        private State(RateLimiterConfig config, long activeCycle, int activePermissions, long nanosToWait) {
            this.config = config;
            this.activeCycle = activeCycle;
            this.activePermissions = activePermissions;
            this.nanosToWait = nanosToWait;
        }
    }
}

