/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnFailureEvent;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnSuccessEvent;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface RateLimiter {
    public static RateLimiter of(String name, RateLimiterConfig rateLimiterConfig) {
        return new AtomicRateLimiter(name, rateLimiterConfig);
    }

    public static RateLimiter of(String name, Supplier<RateLimiterConfig> rateLimiterConfigSupplier) {
        return new AtomicRateLimiter(name, rateLimiterConfigSupplier.get());
    }

    public static RateLimiter ofDefaults(String name) {
        return new AtomicRateLimiter(name, RateLimiterConfig.ofDefaults());
    }

    default public <T> CompletionStage<T> executeCompletionStage(Supplier<CompletionStage<T>> supplier) {
        return RateLimiter.decorateCompletionStage(this, supplier).get();
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(RateLimiter rateLimiter, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            try {
                RateLimiter.waitForPermission(rateLimiter);
                ((CompletionStage)supplier.get()).whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        promise.completeExceptionally((Throwable)throwable);
                    } else {
                        promise.complete(result);
                    }
                });
            }
            catch (Exception exception) {
                promise.completeExceptionally(exception);
            }
            return promise;
        };
    }

    public static <T> CheckedFunction0<T> decorateCheckedSupplier(RateLimiter rateLimiter, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            RateLimiter.waitForPermission(rateLimiter);
            return supplier.apply();
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(RateLimiter rateLimiter, CheckedRunnable runnable) {
        return () -> {
            RateLimiter.waitForPermission(rateLimiter);
            runnable.run();
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(RateLimiter rateLimiter, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            RateLimiter.waitForPermission(rateLimiter);
            return function.apply(t);
        };
    }

    public static <T> Supplier<T> decorateSupplier(RateLimiter rateLimiter, Supplier<T> supplier) {
        return () -> {
            RateLimiter.waitForPermission(rateLimiter);
            return supplier.get();
        };
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(RateLimiter rateLimiter, Supplier<Try<T>> supplier) {
        return () -> {
            try {
                RateLimiter.waitForPermission(rateLimiter);
                return (Try)supplier.get();
            }
            catch (RequestNotPermitted requestNotPermitted) {
                return Try.failure((Throwable)requestNotPermitted);
            }
        };
    }

    public static <T> Supplier<Either<Exception, T>> decorateEitherSupplier(RateLimiter rateLimiter, Supplier<Either<? extends Exception, T>> supplier) {
        return () -> {
            try {
                RateLimiter.waitForPermission(rateLimiter);
                return Either.narrow((Either)((Either)supplier.get()));
            }
            catch (RequestNotPermitted requestNotPermitted) {
                return Either.left((Object)requestNotPermitted);
            }
        };
    }

    public static <T> Callable<T> decorateCallable(RateLimiter rateLimiter, Callable<T> callable) {
        return () -> {
            RateLimiter.waitForPermission(rateLimiter);
            return callable.call();
        };
    }

    public static <T> Consumer<T> decorateConsumer(RateLimiter rateLimiter, Consumer<T> consumer) {
        return t -> {
            RateLimiter.waitForPermission(rateLimiter);
            consumer.accept(t);
        };
    }

    public static Runnable decorateRunnable(RateLimiter rateLimiter, Runnable runnable) {
        return () -> {
            RateLimiter.waitForPermission(rateLimiter);
            runnable.run();
        };
    }

    public static <T, R> Function<T, R> decorateFunction(RateLimiter rateLimiter, Function<T, R> function) {
        return t -> {
            RateLimiter.waitForPermission(rateLimiter);
            return function.apply(t);
        };
    }

    public static void waitForPermission(RateLimiter rateLimiter) {
        boolean permission = rateLimiter.acquirePermission();
        if (Thread.interrupted()) {
            throw new IllegalStateException("Thread was interrupted during permission wait");
        }
        if (!permission) {
            throw new RequestNotPermitted(rateLimiter);
        }
    }

    public void changeTimeoutDuration(Duration var1);

    public void changeLimitForPeriod(int var1);

    public boolean acquirePermission();

    public long reservePermission();

    public String getName();

    public RateLimiterConfig getRateLimiterConfig();

    public Metrics getMetrics();

    public EventPublisher getEventPublisher();

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return RateLimiter.decorateSupplier(this, supplier).get();
    }

    default public <T> Try<T> executeTrySupplier(Supplier<Try<T>> supplier) {
        return RateLimiter.decorateTrySupplier(this, supplier).get();
    }

    default public <T> Either<Exception, T> executeEitherSupplier(Supplier<Either<? extends Exception, T>> supplier) {
        return RateLimiter.decorateEitherSupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return RateLimiter.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        RateLimiter.decorateRunnable(this, runnable).run();
    }

    default public <T> T executeCheckedSupplier(CheckedFunction0<T> checkedSupplier) throws Throwable {
        return (T)RateLimiter.decorateCheckedSupplier(this, checkedSupplier).apply();
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<RateLimiterEvent> {
        public EventPublisher onSuccess(EventConsumer<RateLimiterOnSuccessEvent> var1);

        public EventPublisher onFailure(EventConsumer<RateLimiterOnFailureEvent> var1);
    }

    public static interface Metrics {
        public int getNumberOfWaitingThreads();

        public int getAvailablePermissions();
    }
}

