/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.internal;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnFailureEvent;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnSuccessEvent;
import io.reactivex.Flowable;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class AtomicRateLimiter
implements RateLimiter {
    private static final long nanoTimeStart = System.nanoTime();
    private final String name;
    private final RateLimiterConfig rateLimiterConfig;
    private final long cyclePeriodInNanos;
    private final int permissionsPerCycle;
    private final AtomicInteger waitingThreads;
    private final AtomicReference<State> state;
    private final FlowableProcessor<RateLimiterEvent> eventPublisher;

    public AtomicRateLimiter(String name, RateLimiterConfig rateLimiterConfig) {
        this.name = name;
        this.rateLimiterConfig = rateLimiterConfig;
        this.cyclePeriodInNanos = rateLimiterConfig.getLimitRefreshPeriod().toNanos();
        this.permissionsPerCycle = rateLimiterConfig.getLimitForPeriod();
        this.waitingThreads = new AtomicInteger(0);
        this.state = new AtomicReference<State>(new State(0L, this.permissionsPerCycle, 0L));
        PublishProcessor publisher = PublishProcessor.create();
        this.eventPublisher = publisher.toSerialized();
    }

    private long currentNanoTime() {
        return System.nanoTime() - nanoTimeStart;
    }

    @Override
    public boolean getPermission(Duration timeoutDuration) {
        long timeoutInNanos = timeoutDuration.toNanos();
        State modifiedState = this.updateStateWithBackOff(timeoutInNanos);
        boolean result = this.waitForPermissionIfNecessary(timeoutInNanos, modifiedState.nanosToWait);
        this.publishRateLimiterEvent(result);
        return result;
    }

    private State updateStateWithBackOff(long timeoutInNanos) {
        State next;
        State prev;
        while (!this.compareAndSet(prev = this.state.get(), next = this.calculateNextState(timeoutInNanos, prev))) {
        }
        return next;
    }

    private boolean compareAndSet(State current, State next) {
        if (this.state.compareAndSet(current, next)) {
            return true;
        }
        LockSupport.parkNanos(1L);
        return false;
    }

    private State calculateNextState(long timeoutInNanos, State activeState) {
        long currentNanos = this.currentNanoTime();
        long currentCycle = currentNanos / this.cyclePeriodInNanos;
        long nextCycle = activeState.activeCycle;
        int nextPermissions = activeState.activePermissions;
        if (nextCycle != currentCycle) {
            long elapsedCycles = currentCycle - nextCycle;
            long accumulatedPermissions = elapsedCycles * (long)this.permissionsPerCycle;
            nextCycle = currentCycle;
            nextPermissions = (int)Long.min((long)nextPermissions + accumulatedPermissions, this.permissionsPerCycle);
        }
        long nextNanosToWait = this.nanosToWaitForPermission(nextPermissions, currentNanos, currentCycle);
        State nextState = this.reservePermissions(timeoutInNanos, nextCycle, nextPermissions, nextNanosToWait);
        return nextState;
    }

    private long nanosToWaitForPermission(int availablePermissions, long currentNanos, long currentCycle) {
        if (availablePermissions > 0) {
            return 0L;
        }
        long nextCycleTimeInNanos = (currentCycle + 1L) * this.cyclePeriodInNanos;
        long nanosToNextCycle = nextCycleTimeInNanos - currentNanos;
        int fullCyclesToWait = -availablePermissions / this.permissionsPerCycle;
        return (long)fullCyclesToWait * this.cyclePeriodInNanos + nanosToNextCycle;
    }

    private State reservePermissions(long timeoutInNanos, long cycle, int permissions, long nanosToWait) {
        boolean canAcquireInTime = timeoutInNanos >= nanosToWait;
        int permissionsWithReservation = permissions;
        if (canAcquireInTime) {
            --permissionsWithReservation;
        }
        return new State(cycle, permissionsWithReservation, nanosToWait);
    }

    private boolean waitForPermissionIfNecessary(long timeoutInNanos, long nanosToWait) {
        boolean canAcquireInTime;
        boolean canAcquireImmediately = nanosToWait <= 0L;
        boolean bl = canAcquireInTime = timeoutInNanos >= nanosToWait;
        if (canAcquireImmediately) {
            return true;
        }
        if (canAcquireInTime) {
            return this.waitForPermission(nanosToWait);
        }
        this.waitForPermission(timeoutInNanos);
        return false;
    }

    private boolean waitForPermission(long nanosToWait) {
        this.waitingThreads.incrementAndGet();
        long deadline = this.currentNanoTime() + nanosToWait;
        boolean wasInterrupted = false;
        while (this.currentNanoTime() < deadline && !wasInterrupted) {
            long sleepBlockDuration = deadline - this.currentNanoTime();
            LockSupport.parkNanos(sleepBlockDuration);
            wasInterrupted = Thread.interrupted();
        }
        this.waitingThreads.decrementAndGet();
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return !wasInterrupted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RateLimiterConfig getRateLimiterConfig() {
        return this.rateLimiterConfig;
    }

    @Override
    public RateLimiter.Metrics getMetrics() {
        return new AtomicRateLimiterMetrics();
    }

    @Override
    public Flowable<RateLimiterEvent> getEventStream() {
        return this.eventPublisher;
    }

    public String toString() {
        return "AtomicRateLimiter{name='" + this.name + '\'' + ", rateLimiterConfig=" + this.rateLimiterConfig + '}';
    }

    public AtomicRateLimiterMetrics getDetailedMetrics() {
        return new AtomicRateLimiterMetrics();
    }

    private void publishRateLimiterEvent(boolean permissionAcquired) {
        if (!this.eventPublisher.hasSubscribers()) {
            return;
        }
        if (permissionAcquired) {
            this.eventPublisher.onNext((Object)new RateLimiterOnSuccessEvent(this.name));
            return;
        }
        this.eventPublisher.onNext((Object)new RateLimiterOnFailureEvent(this.name));
    }

    public class AtomicRateLimiterMetrics
    implements RateLimiter.Metrics {
        private AtomicRateLimiterMetrics() {
        }

        @Override
        public int getNumberOfWaitingThreads() {
            return AtomicRateLimiter.this.waitingThreads.get();
        }

        @Override
        public int getAvailablePermissions() {
            State currentState = (State)AtomicRateLimiter.this.state.get();
            State estimatedState = AtomicRateLimiter.this.calculateNextState(-1L, currentState);
            return estimatedState.activePermissions;
        }

        public long getNanosToWait() {
            State currentState = (State)AtomicRateLimiter.this.state.get();
            State estimatedState = AtomicRateLimiter.this.calculateNextState(-1L, currentState);
            return estimatedState.nanosToWait;
        }

        public long getCycle() {
            State currentState = (State)AtomicRateLimiter.this.state.get();
            State estimatedState = AtomicRateLimiter.this.calculateNextState(-1L, currentState);
            return estimatedState.activeCycle;
        }
    }

    private static class State {
        private final long activeCycle;
        private final int activePermissions;
        private final long nanosToWait;

        private State(long activeCycle, int activePermissions, long nanosToWait) {
            this.activeCycle = activeCycle;
            this.activePermissions = activePermissions;
            this.nanosToWait = nanosToWait;
        }
    }
}

