/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.internal;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnFailureEvent;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnSuccessEvent;
import io.github.resilience4j.ratelimiter.internal.RateLimiterEventProcessor;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class AtomicRateLimiter
implements RateLimiter {
    private static final long nanoTimeStart = System.nanoTime();
    private final String name;
    private final AtomicInteger waitingThreads;
    private final AtomicReference<State> state;
    private final Map<String, String> tags;
    private final RateLimiterEventProcessor eventProcessor;

    public AtomicRateLimiter(String name, RateLimiterConfig rateLimiterConfig) {
        this(name, rateLimiterConfig, (Map<String, String>)HashMap.empty());
    }

    public AtomicRateLimiter(String name, RateLimiterConfig rateLimiterConfig, Map<String, String> tags) {
        this.name = name;
        this.tags = tags;
        this.waitingThreads = new AtomicInteger(0);
        this.state = new AtomicReference<State>(new State(rateLimiterConfig, 0L, rateLimiterConfig.getLimitForPeriod(), 0L));
        this.eventProcessor = new RateLimiterEventProcessor();
    }

    @Override
    public void changeTimeoutDuration(Duration timeoutDuration) {
        RateLimiterConfig newConfig = RateLimiterConfig.from(this.state.get().config).timeoutDuration(timeoutDuration).build();
        this.state.updateAndGet(currentState -> new State(newConfig, ((State)currentState).activeCycle, ((State)currentState).activePermissions, ((State)currentState).nanosToWait));
    }

    @Override
    public void changeLimitForPeriod(int limitForPeriod) {
        RateLimiterConfig newConfig = RateLimiterConfig.from(this.state.get().config).limitForPeriod(limitForPeriod).build();
        this.state.updateAndGet(currentState -> new State(newConfig, ((State)currentState).activeCycle, ((State)currentState).activePermissions, ((State)currentState).nanosToWait));
    }

    private long currentNanoTime() {
        return System.nanoTime() - nanoTimeStart;
    }

    @Override
    public boolean acquirePermission(int permits) {
        long timeoutInNanos = this.state.get().config.getTimeoutDuration().toNanos();
        State modifiedState = this.updateStateWithBackOff(permits, timeoutInNanos);
        boolean result = this.waitForPermissionIfNecessary(timeoutInNanos, modifiedState.nanosToWait);
        this.publishRateLimiterEvent(result, permits);
        return result;
    }

    @Override
    public long reservePermission(int permits) {
        boolean canAcquireInTime;
        boolean canAcquireImmediately;
        long timeoutInNanos = this.state.get().config.getTimeoutDuration().toNanos();
        State modifiedState = this.updateStateWithBackOff(permits, timeoutInNanos);
        boolean bl = canAcquireImmediately = modifiedState.nanosToWait <= 0L;
        if (canAcquireImmediately) {
            this.publishRateLimiterEvent(true, permits);
            return 0L;
        }
        boolean bl2 = canAcquireInTime = timeoutInNanos >= modifiedState.nanosToWait;
        if (canAcquireInTime) {
            this.publishRateLimiterEvent(true, permits);
            return modifiedState.nanosToWait;
        }
        this.publishRateLimiterEvent(false, permits);
        return -1L;
    }

    private State updateStateWithBackOff(int permits, long timeoutInNanos) {
        State next;
        State prev;
        while (!this.compareAndSet(prev = this.state.get(), next = this.calculateNextState(permits, timeoutInNanos, prev))) {
        }
        return next;
    }

    private boolean compareAndSet(State current, State next) {
        if (this.state.compareAndSet(current, next)) {
            return true;
        }
        LockSupport.parkNanos(1L);
        return false;
    }

    private State calculateNextState(int permits, long timeoutInNanos, State activeState) {
        long cyclePeriodInNanos = activeState.config.getLimitRefreshPeriod().toNanos();
        int permissionsPerCycle = activeState.config.getLimitForPeriod();
        long currentNanos = this.currentNanoTime();
        long currentCycle = currentNanos / cyclePeriodInNanos;
        long nextCycle = activeState.activeCycle;
        int nextPermissions = activeState.activePermissions;
        if (nextCycle != currentCycle) {
            long elapsedCycles = currentCycle - nextCycle;
            long accumulatedPermissions = elapsedCycles * (long)permissionsPerCycle;
            nextCycle = currentCycle;
            nextPermissions = (int)Long.min((long)nextPermissions + accumulatedPermissions, permissionsPerCycle);
        }
        long nextNanosToWait = this.nanosToWaitForPermission(permits, cyclePeriodInNanos, permissionsPerCycle, nextPermissions, currentNanos, currentCycle);
        State nextState = this.reservePermissions(activeState.config, permits, timeoutInNanos, nextCycle, nextPermissions, nextNanosToWait);
        return nextState;
    }

    private long nanosToWaitForPermission(int permits, long cyclePeriodInNanos, int permissionsPerCycle, int availablePermissions, long currentNanos, long currentCycle) {
        if (availablePermissions >= permits) {
            return 0L;
        }
        long nextCycleTimeInNanos = (currentCycle + 1L) * cyclePeriodInNanos;
        long nanosToNextCycle = nextCycleTimeInNanos - currentNanos;
        int permissionsAtTheStartOfNextCycle = availablePermissions + permissionsPerCycle;
        int fullCyclesToWait = AtomicRateLimiter.divCeil(-(permissionsAtTheStartOfNextCycle - permits), permissionsPerCycle);
        return (long)fullCyclesToWait * cyclePeriodInNanos + nanosToNextCycle;
    }

    private static int divCeil(int x, int y) {
        return (x + y - 1) / y;
    }

    private State reservePermissions(RateLimiterConfig config, int permits, long timeoutInNanos, long cycle, int permissions, long nanosToWait) {
        boolean canAcquireInTime = timeoutInNanos >= nanosToWait;
        int permissionsWithReservation = permissions;
        if (canAcquireInTime) {
            permissionsWithReservation -= permits;
        }
        return new State(config, cycle, permissionsWithReservation, nanosToWait);
    }

    private boolean waitForPermissionIfNecessary(long timeoutInNanos, long nanosToWait) {
        boolean canAcquireInTime;
        boolean canAcquireImmediately = nanosToWait <= 0L;
        boolean bl = canAcquireInTime = timeoutInNanos >= nanosToWait;
        if (canAcquireImmediately) {
            return true;
        }
        if (canAcquireInTime) {
            return this.waitForPermission(nanosToWait);
        }
        this.waitForPermission(timeoutInNanos);
        return false;
    }

    private boolean waitForPermission(long nanosToWait) {
        this.waitingThreads.incrementAndGet();
        long deadline = this.currentNanoTime() + nanosToWait;
        boolean wasInterrupted = false;
        while (this.currentNanoTime() < deadline && !wasInterrupted) {
            long sleepBlockDuration = deadline - this.currentNanoTime();
            LockSupport.parkNanos(sleepBlockDuration);
            wasInterrupted = Thread.interrupted();
        }
        this.waitingThreads.decrementAndGet();
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return !wasInterrupted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RateLimiterConfig getRateLimiterConfig() {
        return this.state.get().config;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public RateLimiter.Metrics getMetrics() {
        return new AtomicRateLimiterMetrics();
    }

    @Override
    public RateLimiter.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    public String toString() {
        return "AtomicRateLimiter{name='" + this.name + '\'' + ", rateLimiterConfig=" + this.state.get().config + '}';
    }

    public AtomicRateLimiterMetrics getDetailedMetrics() {
        return new AtomicRateLimiterMetrics();
    }

    private void publishRateLimiterEvent(boolean permissionAcquired, int permits) {
        if (!this.eventProcessor.hasConsumers()) {
            return;
        }
        if (permissionAcquired) {
            this.eventProcessor.consumeEvent(new RateLimiterOnSuccessEvent(this.name, permits));
            return;
        }
        this.eventProcessor.consumeEvent(new RateLimiterOnFailureEvent(this.name, permits));
    }

    public class AtomicRateLimiterMetrics
    implements RateLimiter.Metrics {
        private AtomicRateLimiterMetrics() {
        }

        @Override
        public int getNumberOfWaitingThreads() {
            return AtomicRateLimiter.this.waitingThreads.get();
        }

        @Override
        public int getAvailablePermissions() {
            State currentState = (State)AtomicRateLimiter.this.state.get();
            State estimatedState = AtomicRateLimiter.this.calculateNextState(1, -1L, currentState);
            return estimatedState.activePermissions;
        }

        public long getNanosToWait() {
            State currentState = (State)AtomicRateLimiter.this.state.get();
            State estimatedState = AtomicRateLimiter.this.calculateNextState(1, -1L, currentState);
            return estimatedState.nanosToWait;
        }

        public long getCycle() {
            State currentState = (State)AtomicRateLimiter.this.state.get();
            State estimatedState = AtomicRateLimiter.this.calculateNextState(1, -1L, currentState);
            return estimatedState.activeCycle;
        }
    }

    private static class State {
        private final RateLimiterConfig config;
        private final long activeCycle;
        private final int activePermissions;
        private final long nanosToWait;

        private State(RateLimiterConfig config, long activeCycle, int activePermissions, long nanosToWait) {
            this.config = config;
            this.activeCycle = activeCycle;
            this.activePermissions = activePermissions;
            this.nanosToWait = nanosToWait;
        }
    }
}

