/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter;

import io.github.resilience4j.core.functions.Either;
import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Predicate;

public class RateLimiterConfig
implements Serializable {
    private static final long serialVersionUID = -1621614587284115957L;
    private static final String TIMEOUT_DURATION_MUST_NOT_BE_NULL = "TimeoutDuration must not be null";
    private static final String TIMEOUT_DURATION_TOO_LARGE = "TimeoutDuration too large";
    private static final String LIMIT_REFRESH_PERIOD_MUST_NOT_BE_NULL = "LimitRefreshPeriod must not be null";
    private static final String LIMIT_REFRESH_PERIOD_TOO_LARGE = "LimitRefreshPeriod too large";
    private static final Duration ACCEPTABLE_REFRESH_PERIOD = Duration.ofNanos(1L);
    private static final boolean DEFAULT_WRITABLE_STACK_TRACE_ENABLED = true;
    private final Duration timeoutDuration;
    private final Duration limitRefreshPeriod;
    private final int limitForPeriod;
    private final transient Predicate<Either<? extends Throwable, ?>> drainPermissionsOnResult;
    private final boolean writableStackTraceEnabled;

    private RateLimiterConfig(Duration timeoutDuration, Duration limitRefreshPeriod, int limitForPeriod, Predicate<Either<? extends Throwable, ?>> drainPermissionsOnResult, boolean writableStackTraceEnabled) {
        this.timeoutDuration = timeoutDuration;
        this.limitRefreshPeriod = limitRefreshPeriod;
        this.limitForPeriod = limitForPeriod;
        this.drainPermissionsOnResult = drainPermissionsOnResult;
        this.writableStackTraceEnabled = writableStackTraceEnabled;
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder from(RateLimiterConfig prototype) {
        return new Builder(prototype);
    }

    public static RateLimiterConfig ofDefaults() {
        return new Builder().build();
    }

    private static Duration checkTimeoutDuration(Duration timeoutDuration) {
        return RateLimiterConfig.validateDurationWithinRange(Objects.requireNonNull(timeoutDuration, TIMEOUT_DURATION_MUST_NOT_BE_NULL), TIMEOUT_DURATION_TOO_LARGE);
    }

    private static Duration validateDurationWithinRange(Duration duration, String message) {
        try {
            duration.toNanos();
            return duration;
        }
        catch (Exception e) {
            throw new RuntimeException(message, e);
        }
    }

    private static Duration checkLimitRefreshPeriod(Duration limitRefreshPeriod) {
        boolean refreshPeriodIsTooShort;
        RateLimiterConfig.validateDurationWithinRange(Objects.requireNonNull(limitRefreshPeriod, LIMIT_REFRESH_PERIOD_MUST_NOT_BE_NULL), LIMIT_REFRESH_PERIOD_TOO_LARGE);
        boolean bl = refreshPeriodIsTooShort = limitRefreshPeriod.compareTo(ACCEPTABLE_REFRESH_PERIOD) < 0;
        if (refreshPeriodIsTooShort) {
            throw new IllegalArgumentException("LimitRefreshPeriod is too short");
        }
        return limitRefreshPeriod;
    }

    private static int checkLimitForPeriod(int limitForPeriod) {
        if (limitForPeriod < 1) {
            throw new IllegalArgumentException("LimitForPeriod should be greater than 0");
        }
        return limitForPeriod;
    }

    public Duration getTimeoutDuration() {
        return this.timeoutDuration;
    }

    public Duration getLimitRefreshPeriod() {
        return this.limitRefreshPeriod;
    }

    public int getLimitForPeriod() {
        return this.limitForPeriod;
    }

    public Predicate<Either<? extends Throwable, ?>> getDrainPermissionsOnResult() {
        return this.drainPermissionsOnResult;
    }

    public boolean isWritableStackTraceEnabled() {
        return this.writableStackTraceEnabled;
    }

    public String toString() {
        return "RateLimiterConfig{timeoutDuration=" + this.timeoutDuration + ", limitRefreshPeriod=" + this.limitRefreshPeriod + ", limitForPeriod=" + this.limitForPeriod + ", writableStackTraceEnabled=" + this.writableStackTraceEnabled + "}";
    }

    public static class Builder {
        private Duration timeoutDuration = Duration.ofSeconds(5L);
        private Duration limitRefreshPeriod = Duration.ofNanos(500L);
        private int limitForPeriod = 50;
        private Predicate<Either<? extends Throwable, ?>> drainPermissionsOnResult = any -> false;
        private boolean writableStackTraceEnabled = true;

        public Builder() {
        }

        public Builder(RateLimiterConfig prototype) {
            this.timeoutDuration = prototype.timeoutDuration;
            this.limitRefreshPeriod = prototype.limitRefreshPeriod;
            this.limitForPeriod = prototype.limitForPeriod;
            this.drainPermissionsOnResult = prototype.drainPermissionsOnResult;
            this.writableStackTraceEnabled = prototype.writableStackTraceEnabled;
        }

        public RateLimiterConfig build() {
            return new RateLimiterConfig(this.timeoutDuration, this.limitRefreshPeriod, this.limitForPeriod, this.drainPermissionsOnResult, this.writableStackTraceEnabled);
        }

        public Builder writableStackTraceEnabled(boolean writableStackTraceEnabled) {
            this.writableStackTraceEnabled = writableStackTraceEnabled;
            return this;
        }

        public Builder drainPermissionsOnResult(Predicate<Either<? extends Throwable, ?>> drainPermissionsOnResult) {
            this.drainPermissionsOnResult = drainPermissionsOnResult;
            return this;
        }

        public Builder timeoutDuration(Duration timeoutDuration) {
            this.timeoutDuration = RateLimiterConfig.checkTimeoutDuration(timeoutDuration);
            return this;
        }

        public Builder limitRefreshPeriod(Duration limitRefreshPeriod) {
            this.limitRefreshPeriod = RateLimiterConfig.checkLimitRefreshPeriod(limitRefreshPeriod);
            return this;
        }

        public Builder limitForPeriod(int limitForPeriod) {
            this.limitForPeriod = RateLimiterConfig.checkLimitForPeriod(limitForPeriod);
            return this;
        }
    }
}

