/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.bulkhead;

import com.google.inject.Inject;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.ratpack.bulkhead.BulkheadTransformer;
import io.github.resilience4j.ratpack.internal.AbstractMethodInterceptor;
import io.github.resilience4j.ratpack.recovery.DefaultRecoveryFunction;
import io.github.resilience4j.ratpack.recovery.RecoveryFunction;
import io.github.resilience4j.reactor.bulkhead.operator.BulkheadOperator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInvocation;
import ratpack.exec.Promise;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BulkheadMethodInterceptor
extends AbstractMethodInterceptor {
    @Inject(optional=true)
    @Nullable
    private BulkheadRegistry registry;

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        io.github.resilience4j.bulkhead.annotation.Bulkhead annotation = invocation.getMethod().getAnnotation(io.github.resilience4j.bulkhead.annotation.Bulkhead.class);
        if (annotation == null) {
            annotation = invocation.getMethod().getDeclaringClass().getAnnotation(io.github.resilience4j.bulkhead.annotation.Bulkhead.class);
        }
        RecoveryFunction fallbackMethod = Optional.ofNullable(this.createRecoveryFunction(invocation, annotation.fallbackMethod())).orElse(new DefaultRecoveryFunction());
        if (this.registry == null) {
            this.registry = BulkheadRegistry.ofDefaults();
        }
        Bulkhead bulkhead = this.registry.bulkhead(annotation.name());
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (Promise.class.isAssignableFrom(returnType)) {
            Promise result = (Promise)this.proceed(invocation);
            if (result != null) {
                BulkheadTransformer transformer = BulkheadTransformer.of(bulkhead).recover(fallbackMethod);
                result = result.transform(transformer);
            }
            return result;
        }
        if (Flux.class.isAssignableFrom(returnType)) {
            Flux result = (Flux)this.proceed(invocation);
            if (result != null) {
                BulkheadOperator operator = BulkheadOperator.of((Bulkhead)bulkhead);
                result = fallbackMethod.onErrorResume(result.transform((Function)operator));
            }
            return result;
        }
        if (Mono.class.isAssignableFrom(returnType)) {
            Mono result = (Mono)this.proceed(invocation);
            if (result != null) {
                BulkheadOperator operator = BulkheadOperator.of((Bulkhead)bulkhead);
                result = fallbackMethod.onErrorResume(result.transform((Function)operator));
            }
            return result;
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            CompletableFuture promise = new CompletableFuture();
            if (bulkhead.tryAcquirePermission()) {
                CompletionStage result = (CompletionStage)this.proceed(invocation);
                if (result != null) {
                    result.whenComplete((value, throwable) -> {
                        bulkhead.onComplete();
                        if (throwable != null) {
                            this.completeFailedFuture((Throwable)throwable, fallbackMethod, promise);
                        } else {
                            promise.complete(value);
                        }
                    });
                }
            } else {
                BulkheadFullException t = BulkheadFullException.createBulkheadFullException((Bulkhead)bulkhead);
                this.completeFailedFuture((Throwable)t, fallbackMethod, promise);
            }
            return promise;
        }
        return this.handleProceedWithException(invocation, bulkhead, fallbackMethod);
    }

    @Nullable
    private Object handleProceedWithException(MethodInvocation invocation, Bulkhead bulkhead, RecoveryFunction<?> recoveryFunction) throws Throwable {
        try {
            return Bulkhead.decorateCheckedSupplier((Bulkhead)bulkhead, () -> ((MethodInvocation)invocation).proceed()).apply();
        }
        catch (Throwable throwable) {
            return recoveryFunction.apply(throwable);
        }
    }
}

