/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.bulkhead;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.ratpack.internal.AbstractTransformer;
import ratpack.exec.Downstream;
import ratpack.exec.Upstream;
import ratpack.func.Function;

public class BulkheadTransformer<T>
extends AbstractTransformer<T> {
    private final Bulkhead bulkhead;

    private BulkheadTransformer(Bulkhead bulkhead) {
        this.bulkhead = bulkhead;
    }

    public static <T> BulkheadTransformer<T> of(Bulkhead bulkhead) {
        return new BulkheadTransformer<T>(bulkhead);
    }

    public BulkheadTransformer<T> recover(Function<Throwable, ? extends T> recoverer) {
        this.recoverer = recoverer;
        return this;
    }

    public Upstream<T> apply(Upstream<? extends T> upstream) throws Exception {
        return down -> {
            if (this.bulkhead.tryAcquirePermission()) {
                upstream.connect(new Downstream<T>(){

                    public void success(T value) {
                        BulkheadTransformer.this.bulkhead.onComplete();
                        down.success(value);
                    }

                    public void error(Throwable throwable) {
                        BulkheadTransformer.this.bulkhead.onComplete();
                        BulkheadTransformer.this.handleRecovery(down, throwable);
                    }

                    public void complete() {
                        BulkheadTransformer.this.bulkhead.releasePermission();
                        down.complete();
                    }
                });
            } else {
                BulkheadFullException t = BulkheadFullException.createBulkheadFullException((Bulkhead)this.bulkhead);
                this.handleRecovery(down, (Throwable)t);
            }
        };
    }
}

