/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.circuitbreaker.monitoring.endpoint;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerEventDTOFactory;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerEventsEndpointResponse;
import io.github.resilience4j.common.circuitbreaker.monitoring.endpoint.CircuitBreakerHystrixStreamEventsDTO;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventPublisher;
import io.github.resilience4j.ratpack.Resilience4jConfig;
import io.github.resilience4j.ratpack.circuitbreaker.monitoring.endpoint.metrics.CircuitBreakerMetricsDTO;
import io.github.resilience4j.ratpack.circuitbreaker.monitoring.endpoint.states.CircuitBreakerStateDTO;
import io.github.resilience4j.ratpack.circuitbreaker.monitoring.endpoint.states.CircuitBreakerStatesEndpointResponse;
import io.github.resilience4j.reactor.adapter.ReactorAdapter;
import io.vavr.collection.Seq;
import java.util.Comparator;
import javax.inject.Inject;
import org.reactivestreams.Publisher;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Chain;
import ratpack.jackson.Jackson;
import ratpack.registry.Registry;
import ratpack.sse.ServerSentEvents;
import reactor.core.publisher.Flux;

public class CircuitBreakerChain
implements Action<Chain> {
    private final EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry;
    private final CircuitBreakerRegistry circuitBreakerRegistry;

    @Inject
    public CircuitBreakerChain(EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry, CircuitBreakerRegistry circuitBreakerRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
        this.circuitBreakerRegistry = circuitBreakerRegistry;
    }

    public void execute(Chain chain) throws Exception {
        String prefix = ((Resilience4jConfig)chain.getRegistry().get(Resilience4jConfig.class)).getEndpoints().getCircuitbreaker().getPath();
        chain.prefix(prefix, chain1 -> {
            chain1.get("states/:name", ctx -> {
                String circuitBreakerName = (String)ctx.getPathTokens().get((Object)"name");
                Promise.async(d -> {
                    CircuitBreakerStatesEndpointResponse response = new CircuitBreakerStatesEndpointResponse(this.circuitBreakerRegistry.getAllCircuitBreakers().filter(c -> c.getName().equals(circuitBreakerName)).map(c -> new CircuitBreakerStateDTO(c.getName(), c.getState(), new CircuitBreakerMetricsDTO(c.getMetrics()))).toJavaList());
                    d.success((Object)response);
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("states", ctx -> Promise.async(d -> {
                CircuitBreakerStatesEndpointResponse response = new CircuitBreakerStatesEndpointResponse(this.circuitBreakerRegistry.getAllCircuitBreakers().map(c -> new CircuitBreakerStateDTO(c.getName(), c.getState(), new CircuitBreakerMetricsDTO(c.getMetrics()))).toJavaList());
                d.success((Object)response);
            }).then(r -> ctx.render((Object)Jackson.json((Object)r))));
            chain1.get("events", ctx -> Promise.async(d -> {
                CircuitBreakerEventsEndpointResponse response = new CircuitBreakerEventsEndpointResponse(this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(CircuitBreakerEvent::getCreationTime)).map(CircuitBreakerEventDTOFactory::createCircuitBreakerEventDTO).toJavaList());
                d.success((Object)response);
            }).then(r -> ctx.render((Object)Jackson.json((Object)r))));
            chain1.get("stream/events", ctx -> {
                Seq eventStreams = this.circuitBreakerRegistry.getAllCircuitBreakers().map(circuitBreaker -> ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()));
                Function data = c -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)CircuitBreakerEventDTOFactory.createCircuitBreakerEventDTO((CircuitBreakerEvent)c));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)Flux.merge((Iterable)eventStreams), e -> e.id(CircuitBreakerEvent::getCircuitBreakerName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("hystrixStream/events", ctx -> {
                Seq eventStreams = this.circuitBreakerRegistry.getAllCircuitBreakers().map(circuitBreaker -> ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()));
                Function data = c -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)this.circuitBreakerRegistry.getAllCircuitBreakers().filter(cb -> cb.getName().equals(c.getCircuitBreakerName())).map(cb -> new CircuitBreakerHystrixStreamEventsDTO(c, cb.getState(), cb.getMetrics(), cb.getCircuitBreakerConfig())));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)Flux.merge((Iterable)eventStreams), e -> e.id(CircuitBreakerEvent::getCircuitBreakerName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("events/:name", ctx -> {
                String circuitBreakerName = (String)ctx.getPathTokens().get((Object)"name");
                Promise.async(d -> {
                    CircuitBreakerEventsEndpointResponse response = new CircuitBreakerEventsEndpointResponse(this.eventConsumerRegistry.getEventConsumer(circuitBreakerName).getBufferedEvents().map(CircuitBreakerEventDTOFactory::createCircuitBreakerEventDTO).toJavaList());
                    d.success((Object)response);
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("stream/events/:name", ctx -> {
                String circuitBreakerName = (String)ctx.getPathTokens().get((Object)"name");
                CircuitBreaker circuitBreaker = (CircuitBreaker)this.circuitBreakerRegistry.getAllCircuitBreakers().find(cb -> cb.getName().equals(circuitBreakerName)).getOrElseThrow(() -> new IllegalArgumentException(String.format("circuit breaker with name %s not found", circuitBreakerName)));
                Function data = c -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)CircuitBreakerEventDTOFactory.createCircuitBreakerEventDTO((CircuitBreakerEvent)c));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()), e -> e.id(CircuitBreakerEvent::getCircuitBreakerName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("hystrixStream/events/:name", ctx -> {
                String circuitBreakerName = (String)ctx.getPathTokens().get((Object)"name");
                CircuitBreaker circuitBreaker = (CircuitBreaker)this.circuitBreakerRegistry.getAllCircuitBreakers().find(cb -> cb.getName().equals(circuitBreakerName)).getOrElseThrow(() -> new IllegalArgumentException(String.format("circuit breaker with name %s not found", circuitBreakerName)));
                Function data = c -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)new CircuitBreakerHystrixStreamEventsDTO(c, circuitBreaker.getState(), circuitBreaker.getMetrics(), circuitBreaker.getCircuitBreakerConfig()));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()), e -> e.id(CircuitBreakerEvent::getCircuitBreakerName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("events/:name/:type", ctx -> {
                String circuitBreakerName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                Promise.async(d -> {
                    CircuitBreakerEventsEndpointResponse response = new CircuitBreakerEventsEndpointResponse(this.eventConsumerRegistry.getEventConsumer(circuitBreakerName).getBufferedEvents().filter(event -> event.getEventType() == CircuitBreakerEvent.Type.valueOf((String)eventType.toUpperCase())).map(CircuitBreakerEventDTOFactory::createCircuitBreakerEventDTO).toJavaList());
                    d.success((Object)response);
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("stream/events/:name/:type", ctx -> {
                String circuitBreakerName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                CircuitBreaker circuitBreaker = (CircuitBreaker)this.circuitBreakerRegistry.getAllCircuitBreakers().find(cb -> cb.getName().equals(circuitBreakerName)).getOrElseThrow(() -> new IllegalArgumentException(String.format("circuit breaker with name %s not found", circuitBreakerName)));
                Flux eventStream = ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()).filter(event -> event.getEventType() == CircuitBreakerEvent.Type.valueOf((String)eventType.toUpperCase()));
                Function data = c -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)CircuitBreakerEventDTOFactory.createCircuitBreakerEventDTO((CircuitBreakerEvent)c));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)eventStream, e -> e.id(CircuitBreakerEvent::getCircuitBreakerName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("hystrixStream/events/:name/:type", ctx -> {
                String circuitBreakerName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                CircuitBreaker circuitBreaker = (CircuitBreaker)this.circuitBreakerRegistry.getAllCircuitBreakers().find(cb -> cb.getName().equals(circuitBreakerName)).getOrElseThrow(() -> new IllegalArgumentException(String.format("circuit breaker with name %s not found", circuitBreakerName)));
                Flux eventStream = ReactorAdapter.toFlux((EventPublisher)circuitBreaker.getEventPublisher()).filter(event -> event.getEventType() == CircuitBreakerEvent.Type.valueOf((String)eventType.toUpperCase()));
                Function data = c -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)new CircuitBreakerHystrixStreamEventsDTO(c, circuitBreaker.getState(), circuitBreaker.getMetrics(), circuitBreaker.getCircuitBreakerConfig()));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)eventStream, e -> e.id(CircuitBreakerEvent::getCircuitBreakerName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
        });
    }
}

