/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.retry;

import com.google.inject.Inject;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.ratpack.internal.AbstractMethodInterceptor;
import io.github.resilience4j.ratpack.recovery.DefaultRecoveryFunction;
import io.github.resilience4j.ratpack.recovery.RecoveryFunction;
import io.github.resilience4j.ratpack.retry.RetryTransformer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.aopalliance.intercept.MethodInvocation;
import ratpack.exec.Downstream;
import ratpack.exec.Promise;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class RetryMethodInterceptor
extends AbstractMethodInterceptor {
    @Inject(optional=true)
    @Nullable
    private RetryRegistry registry;

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        io.github.resilience4j.retry.annotation.Retry annotation = invocation.getMethod().getAnnotation(io.github.resilience4j.retry.annotation.Retry.class);
        if (annotation == null) {
            annotation = invocation.getMethod().getDeclaringClass().getAnnotation(io.github.resilience4j.retry.annotation.Retry.class);
        }
        if (this.registry == null) {
            this.registry = RetryRegistry.ofDefaults();
        }
        Retry retry = this.registry.retry(annotation.name());
        RecoveryFunction fallbackMethod = Optional.ofNullable(this.createRecoveryFunction(invocation, annotation.fallbackMethod())).orElse(new DefaultRecoveryFunction());
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (Promise.class.isAssignableFrom(returnType)) {
            Promise result = (Promise)this.proceed(invocation);
            if (result != null) {
                RetryTransformer transformer = RetryTransformer.of(retry).recover(fallbackMethod);
                result = result.transform(transformer);
            }
            return result;
        }
        if (Flux.class.isAssignableFrom(returnType)) {
            Flux result = (Flux)this.proceed(invocation);
            if (result != null) {
                RetryTransformer transformer = RetryTransformer.of(retry).recover(fallbackMethod);
                Flux temp = result;
                Promise promise = Promise.async(arg_0 -> RetryMethodInterceptor.lambda$invoke$0((Flux)temp, arg_0)).transform(transformer);
                Flux next = Flux.create(subscriber -> promise.onError(arg_0 -> ((FluxSink)subscriber).error(arg_0)).then(value -> {
                    subscriber.next(value);
                    subscriber.complete();
                }));
                result = fallbackMethod.onErrorResume(next);
            }
            return result;
        }
        if (Mono.class.isAssignableFrom(returnType)) {
            Mono result = (Mono)this.proceed(invocation);
            if (result != null) {
                RetryTransformer transformer = RetryTransformer.of(retry).recover(fallbackMethod);
                Mono temp = result;
                Promise promise = Promise.async(arg_0 -> RetryMethodInterceptor.lambda$invoke$3((Mono)temp, arg_0)).transform(transformer);
                Mono next = Mono.create(subscriber -> promise.onError(arg_0 -> ((MonoSink)subscriber).error(arg_0)).then(arg_0 -> ((MonoSink)subscriber).success(arg_0)));
                result = fallbackMethod.onErrorResume(next);
            }
            return result;
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            CompletionStage stage = (CompletionStage)this.proceed(invocation);
            return this.executeCompletionStage(invocation, stage, retry.context(), fallbackMethod);
        }
        return this.handleProceedWithException(invocation, retry, fallbackMethod);
    }

    private CompletionStage<?> executeCompletionStage(MethodInvocation invocation, CompletionStage<?> stage, Retry.Context context, RecoveryFunction<?> recoveryFunction) {
        CompletableFuture promise = new CompletableFuture();
        stage.whenComplete((v, t) -> {
            if (t != null) {
                try {
                    context.onError((Exception)t);
                    CompletionStage next = (CompletionStage)invocation.proceed();
                    CompletableFuture<?> temp = this.executeCompletionStage(invocation, next, context, recoveryFunction).toCompletableFuture();
                    promise.complete(temp.join());
                }
                catch (Throwable t2) {
                    this.completeFailedFuture(t2, recoveryFunction, promise);
                }
            } else {
                context.onComplete();
                promise.complete(v);
            }
        });
        return promise;
    }

    @Nullable
    private Object handleProceedWithException(MethodInvocation invocation, Retry retry, RecoveryFunction<?> recoveryFunction) throws Throwable {
        try {
            return Retry.decorateCheckedSupplier((Retry)retry, () -> ((MethodInvocation)invocation).proceed()).apply();
        }
        catch (Throwable t) {
            return recoveryFunction.apply(t);
        }
    }

    private static /* synthetic */ void lambda$invoke$3(Mono temp, Downstream f) throws Exception {
        temp.subscribe(arg_0 -> ((Downstream)f).success(arg_0), arg_0 -> ((Downstream)f).error(arg_0));
    }

    private static /* synthetic */ void lambda$invoke$0(Flux temp, Downstream f) throws Exception {
        temp.collectList().subscribe(arg_0 -> ((Downstream)f).success(arg_0), arg_0 -> ((Downstream)f).error(arg_0));
    }
}

