/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.reactor.Permit;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;

class BulkheadSubscriber<T>
extends BaseSubscriber<T> {
    private final CoreSubscriber<? super T> actual;
    private final Bulkhead bulkhead;
    private final AtomicReference<Permit> permitted = new AtomicReference<Permit>(Permit.PENDING);

    public BulkheadSubscriber(Bulkhead bulkhead, CoreSubscriber<? super T> actual) {
        this.actual = actual;
        this.bulkhead = Objects.requireNonNull(bulkhead);
    }

    public void hookOnSubscribe(Subscription subscription) {
        if (this.acquireCallPermit()) {
            this.actual.onSubscribe((Subscription)this);
        } else {
            this.cancel();
            this.actual.onSubscribe((Subscription)this);
            this.actual.onError((Throwable)new BulkheadFullException(String.format("Bulkhead '%s' is full", this.bulkhead.getName())));
        }
    }

    public void hookOnNext(T t) {
        if (this.notCancelled() && this.wasCallPermitted()) {
            this.actual.onNext(t);
        }
    }

    public void hookOnError(Throwable t) {
        if (this.wasCallPermitted()) {
            this.bulkhead.onComplete();
            this.actual.onError(t);
        }
    }

    public void hookOnComplete() {
        if (this.wasCallPermitted()) {
            this.releaseBulkhead();
            this.actual.onComplete();
        }
    }

    private boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(Permit.PENDING, Permit.ACQUIRED) && !(callPermitted = this.bulkhead.isCallPermitted())) {
            this.permitted.set(Permit.REJECTED);
        }
        return callPermitted;
    }

    private boolean notCancelled() {
        return !this.isDisposed();
    }

    private boolean wasCallPermitted() {
        return this.permitted.get() == Permit.ACQUIRED;
    }

    private void releaseBulkhead() {
        if (this.wasCallPermitted()) {
            this.bulkhead.onComplete();
        }
    }
}

