/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.reactor.Permit;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;

class RateLimiterSubscriber<T>
extends BaseSubscriber<T> {
    private final CoreSubscriber<? super T> actual;
    private final RateLimiter rateLimiter;
    private final AtomicReference<Permit> permitted = new AtomicReference<Permit>(Permit.PENDING);
    private final AtomicBoolean firstEvent = new AtomicBoolean(true);

    public RateLimiterSubscriber(RateLimiter rateLimiter, CoreSubscriber<? super T> actual) {
        this.actual = actual;
        this.rateLimiter = Objects.requireNonNull(rateLimiter);
    }

    public void hookOnSubscribe(Subscription subscription) {
        if (this.acquireCallPermit()) {
            this.actual.onSubscribe((Subscription)this);
        } else {
            this.cancel();
            this.actual.onSubscribe((Subscription)this);
            this.actual.onError((Throwable)this.rateLimitExceededException());
        }
    }

    public void hookOnNext(T t) {
        if (this.notCancelled() && this.wasCallPermitted()) {
            if (this.firstEvent.getAndSet(false) || this.rateLimiter.getPermission(this.rateLimiter.getRateLimiterConfig().getTimeoutDuration())) {
                this.actual.onNext(t);
            } else {
                this.cancel();
                this.actual.onError((Throwable)this.rateLimitExceededException());
            }
        }
    }

    public void hookOnError(Throwable t) {
        if (this.wasCallPermitted()) {
            this.actual.onError(t);
        }
    }

    public void hookOnComplete() {
        if (this.wasCallPermitted()) {
            this.actual.onComplete();
        }
    }

    private boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(Permit.PENDING, Permit.ACQUIRED) && !(callPermitted = this.rateLimiter.getPermission(this.rateLimiter.getRateLimiterConfig().getTimeoutDuration()))) {
            this.permitted.set(Permit.REJECTED);
        }
        return callPermitted;
    }

    private boolean notCancelled() {
        return !this.isDisposed();
    }

    private boolean wasCallPermitted() {
        return this.permitted.get() == Permit.ACQUIRED;
    }

    private Exception rateLimitExceededException() {
        return new RequestNotPermitted("Request not permitted for limiter: " + this.rateLimiter.getName());
    }
}

