/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.circuitbreaker.operator;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerOpenException;
import io.github.resilience4j.core.StopWatch;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.reactor.ResilienceBaseSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.core.CoreSubscriber;

class CircuitBreakerSubscriber<T>
extends ResilienceBaseSubscriber<T> {
    private final CircuitBreaker circuitBreaker;
    @Nullable
    private StopWatch stopWatch;
    private final boolean singleProducer;
    private volatile int successSignaled = 0;
    private static final AtomicIntegerFieldUpdater<CircuitBreakerSubscriber> SUCCESS_SIGNALED = AtomicIntegerFieldUpdater.newUpdater(CircuitBreakerSubscriber.class, "successSignaled");

    public CircuitBreakerSubscriber(CircuitBreaker circuitBreaker, CoreSubscriber<? super T> actual, boolean singleProducer) {
        super(actual);
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
        this.singleProducer = singleProducer;
    }

    @Override
    protected void hookOnNext(T value) {
        if (this.singleProducer && SUCCESS_SIGNALED.compareAndSet(this, 0, 1)) {
            this.markSuccess();
        }
        if (this.notCancelled() && this.wasCallPermitted()) {
            this.actual.onNext(value);
        }
    }

    @Override
    protected void hookOnComplete() {
        if (SUCCESS_SIGNALED.compareAndSet(this, 0, 1)) {
            this.markSuccess();
        }
        if (this.wasCallPermitted()) {
            this.actual.onComplete();
        }
    }

    @Override
    protected void hookOnError(Throwable t) {
        Objects.requireNonNull(t);
        this.markFailure(t);
        if (this.wasCallPermitted()) {
            this.actual.onError(t);
        }
    }

    @Override
    protected void hookOnPermitAcquired() {
        this.stopWatch = StopWatch.start((String)this.circuitBreaker.getName());
    }

    @Override
    protected boolean isCallPermitted() {
        return this.circuitBreaker.isCallPermitted();
    }

    @Override
    protected Throwable getThrowable() {
        return new CircuitBreakerOpenException(String.format("CircuitBreaker '%s' is open", this.circuitBreaker.getName()));
    }

    private void markFailure(Throwable e) {
        if (this.wasCallPermitted()) {
            this.circuitBreaker.onError(this.stopWatch.stop().getProcessingDuration().toNanos(), e);
        }
    }

    private void markSuccess() {
        if (this.wasCallPermitted()) {
            this.circuitBreaker.onSuccess(this.stopWatch.stop().getProcessingDuration().toNanos());
        }
    }
}

