/*
 * Copyright 2018 Julien Hoarau, Robert Winkler
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.reactor.AbstractSubscriber;
import org.reactivestreams.Subscriber;
import reactor.core.CoreSubscriber;

/**
 * A Reactor {@link Subscriber} to wrap another subscriber in a bulkhead.
 *
 * @param <T> the value type of the upstream and downstream
 */
class RateLimiterSubscriber<T> extends AbstractSubscriber<T> {

    protected RateLimiterSubscriber(CoreSubscriber<? super T> downstreamSubscriber) {
        super(downstreamSubscriber);
    }

    @Override
    public void hookOnNext(T t) {
        if (!isDisposed()) {
            downstreamSubscriber.onNext(t);
        }
    }

    @Override
    public void hookOnError(Throwable t) {
        downstreamSubscriber.onError(t);
    }

    @Override
    public void hookOnComplete() {
        downstreamSubscriber.onComplete();
    }
}
