/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.reactor.AbstractSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import reactor.core.CoreSubscriber;

class BulkheadSubscriber<T>
extends AbstractSubscriber<T> {
    private final Bulkhead bulkhead;
    private final boolean singleProducer;
    private volatile int successSignaled = 0;
    private static final AtomicIntegerFieldUpdater<BulkheadSubscriber> SUCCESS_SIGNALED = AtomicIntegerFieldUpdater.newUpdater(BulkheadSubscriber.class, "successSignaled");

    BulkheadSubscriber(Bulkhead bulkhead, CoreSubscriber<? super T> downstreamSubscriber, boolean singleProducer) {
        super(downstreamSubscriber);
        this.bulkhead = Objects.requireNonNull(bulkhead);
        this.singleProducer = singleProducer;
    }

    public void hookOnNext(T t) {
        if (!this.isDisposed()) {
            if (this.singleProducer && SUCCESS_SIGNALED.compareAndSet(this, 0, 1)) {
                this.bulkhead.onComplete();
            }
            this.downstreamSubscriber.onNext(t);
        }
    }

    public void hookOnCancel() {
        if (this.successSignaled == 0) {
            this.bulkhead.releasePermission();
        }
    }

    public void hookOnError(Throwable t) {
        this.bulkhead.onComplete();
        this.downstreamSubscriber.onError(t);
    }

    public void hookOnComplete() {
        if (SUCCESS_SIGNALED.compareAndSet(this, 0, 1)) {
            this.bulkhead.onComplete();
        }
        this.downstreamSubscriber.onComplete();
    }
}

