/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.reactor.ratelimiter.operator.RateLimiterSubscriber;
import java.time.Duration;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

class FluxRateLimiter<T>
extends FluxOperator<T, T> {
    private final RateLimiter rateLimiter;
    private final Scheduler scheduler;

    FluxRateLimiter(Flux<? extends T> source, RateLimiter rateLimiter, Scheduler scheduler) {
        super(source);
        this.rateLimiter = rateLimiter;
        this.scheduler = scheduler;
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        if (this.rateLimiter.acquirePermission(Duration.ZERO)) {
            this.source.publishOn(this.scheduler).subscribe(new RateLimiterSubscriber<T>(actual));
        } else {
            Operators.error(actual, (Throwable)new RequestNotPermitted(this.rateLimiter));
        }
    }
}

