/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.reactor.ratelimiter.operator.RateLimiterSubscriber;
import java.time.Duration;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

class MonoRateLimiter<T>
extends MonoOperator<T, T> {
    private final RateLimiter rateLimiter;
    private final Scheduler scheduler;

    MonoRateLimiter(Mono<? extends T> source, RateLimiter rateLimiter, Scheduler scheduler) {
        super(source);
        this.rateLimiter = rateLimiter;
        this.scheduler = scheduler;
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        if (this.rateLimiter.acquirePermission(Duration.ZERO)) {
            this.source.publishOn(this.scheduler).subscribe(new RateLimiterSubscriber<T>(actual));
        } else {
            Operators.error(actual, (Throwable)new RequestNotPermitted(this.rateLimiter));
        }
    }
}

